﻿/*
 * Copyright (c) eHealth
 */

using System;
using be.ehealth.technicalconnector.idgenerator;
using be.fgov.ehealth.commons.core.v2;
using be.fgov.ehealth.dics.protocol.v3;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using java.lang;
using org.joda.time;
using org.slf4j;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.businessconnector.dicsv3.session;
using be.ehealth.businessconnector.test.testcommons.utils;
/**
 * Integration tests for tarification.
 * 
 * @author eHealth Platform
 * 
 */
namespace be.ehealth.businessconnector.dicsv3.session
{
public class DicsIntegrationTest {
	    
    [SetUpAttribute]
    public static void setupsession() {
    	SessionInitializer.init(".\\be.ehealth.businessconnector.dicsv3.test.properties",true, SupportedLanguages.NET.getAbbreviation());
    }

    [TearDownAttribute]
    public static void teardownSession() {
        Session.getInstance().unloadSession();
    }

    [Test]
    public void findAmpTestXmlNoDataFound() {
        FindAmpResponse response = findAmpTest(".\\examples\\findAmpRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue(),"The second status is not a data not found");
    }

    [Test]
    public void findAmpTestXml() {
        FindAmpResponse response = findAmpTest(".\\examples\\findAmpRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(),"The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(),"The status is not a success");
        Assert.IsTrue(response.getAmps().size() >= 1,"No amps found");
    }

    private FindAmpResponse findAmpTest(string location) {
        FindAmpRequest request = (FindAmpRequest) MarshallerUtils.toObject(location, typeof(FindAmpRequest));

        return DicsSessionServiceFactory.getDicsSession().findAmp(request);
    }

    [Test]
    public void findCommentedClassificationXmlNoDataFound() {
        FindCommentedClassificationResponse response = findCommentedClassification(".\\examples\\findCommentedClassificationRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue(), "The second status is not a data not found");
    }

    [Test]
    [Ignore("Waiting for service to provide data")]
    public void findCommentedClassificationXml() {
        FindCommentedClassificationResponse response = findCommentedClassification(".\\examples\\findCommentedClassificationRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getCommentedClassifications().size() >= 1, "No commented classification found");
    }

    private FindCommentedClassificationResponse findCommentedClassification(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindCommentedClassificationRequest), typeof(FindCommentedClassificationRequest));
        FindCommentedClassificationRequest request = (FindCommentedClassificationRequest)marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findCommentedClassification(request);
    }

    [Test]
    public void findCompanyXmlNoDataFound() {
        FindCompanyResponse response = findCompany(".\\examples\\findCompanyRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(),"The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue(), "The second status is not a data not found");
    }

    [Test]
    public void findCompanyXml() {
        FindCompanyResponse response = findCompany(".\\examples\\findCompanyRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getCompanies().size() >= 1, "No companies found");
    }

    private FindCompanyResponse findCompany(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindCompanyRequest), typeof(FindCompanyRequest));
        FindCompanyRequest request = (FindCompanyRequest) marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findCompany(request);
    }

    [Test]
    public void findFormulaXmlNoDataFound() {
        FindCompoundingFormulaResponse response = findFormula(".\\examples\\findFormulaRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue(), "The second status is not a data not found");
    }

    [Test]
    [Ignore("Waiting for service to provide data")]
    public void findFormulaXml() {
        FindCompoundingFormulaResponse response = findFormula(".\\examples\\findFormulaRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getCompoundingFormulas().size() >= 1, "No commented classification found");
    }

    private FindCompoundingFormulaResponse findFormula(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindCompoundingFormulaRequest), typeof(FindCompoundingFormulaRequest));
        FindCompoundingFormulaRequest request = (FindCompoundingFormulaRequest) marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findFormula(request);
    }

    [Test]
    public void findIngredientXmlNoDataFound() {
        FindCompoundingIngredientResponse response = findIngredient(".\\examples\\findIngredientRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue(), "The second status is not a data not found");
    }

    [Test]
    [Ignore("Waiting for service to provide data")]
    public void findIngredientXml() {
        FindCompoundingIngredientResponse response = findIngredient(".\\examples\\findIngredientRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getCompoundingIngredients().size() >= 1, "No commented classification found");
    }

    private FindCompoundingIngredientResponse findIngredient(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindCompoundingIngredientRequest), typeof(FindCompoundingIngredientRequest));
        FindCompoundingIngredientRequest request = (FindCompoundingIngredientRequest) marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findIngredient(request);
    }

    [Test]
    public void findLegislationXmlNoDataFound() {
        FindLegislationTextResponse response = findLegislation(".\\examples\\findLegislationTextRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue(), "The second status is not a data not found");
    }

    [Test]
    public void findLegislationXml() {
        FindLegislationTextResponse response = findLegislation(".\\examples\\findLegislationTextRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getLegalbases().size() >= 1, "No commented classification found");
    }

    private FindLegislationTextResponse findLegislation(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindLegislationTextRequest), typeof(FindLegislationTextRequest));
        FindLegislationTextRequest request = (FindLegislationTextRequest) marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findLegislationText(request);
    }

    [Test]
    public void findReferencesXml() {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(".\\examples\\findReferencesRequest.xml");
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindReferencesRequest), typeof(FindReferencesRequest));
        FindReferencesRequest request = (FindReferencesRequest) marshaller.toObject(inputStream);

        FindReferencesResponse response = DicsSessionServiceFactory.getDicsSession().findReferences(request);

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getWadas().size() >= 1, "No commented classification found");
    }

    [Test]
    public void findReimboursementXmlNoDataFound() {
        FindReimbursementResponse response = findReimboursement(".\\examples\\findReimboursementRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
    }

    [Test]
    [Ignore("Waiting for service to provide data")]
    public void findReimboursementXml() {
        FindReimbursementResponse response = findReimboursement(".\\examples\\findReimboursementRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getReimbursementContexts().size() >= 1, "No commented classification found");
    }

    private FindReimbursementResponse findReimboursement(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindReimbursementRequest), typeof(FindReimbursementRequest));
        FindReimbursementRequest request = (FindReimbursementRequest) marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findReimbursement(request);
    }

    [Test]
    public void findVmpGroupXmlNoDataFound() {
        FindVmpGroupResponse response = findVmpGroup(".\\examples\\findVmpGroupRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
    }

    [Test]
    public void findVmpGroupXml() {
        FindVmpGroupResponse response = findVmpGroup(".\\examples\\findVmpGroupRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getVmpGroups().size() >= 1, "No commented classification found");
    }

    private FindVmpGroupResponse findVmpGroup(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindVmpGroupRequest), typeof(FindVmpGroupRequest));
        FindVmpGroupRequest request = (FindVmpGroupRequest) marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findVmpGroup(request);
    }

    [Test]
    public void findVmpXmlNoDataFound() {
        FindVmpResponse response = findVmp(".\\examples\\findVmpRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
    }

    [Test]
    public void findVmpXml() {
        FindVmpResponse response = findVmp(".\\examples\\findVmpRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getVmps().size() >= 1, "No commented classification found");
    }

    private FindVmpResponse findVmp(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindVmpRequest), typeof(FindVmpRequest));
        FindVmpRequest request = (FindVmpRequest) marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findVmp(request);
    }

    [Test]
    public void findVtmXmlNoDataFound() {
        FindVtmResponse response = findVtm(".\\examples\\findVtmRequest-noDataFound.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
    }

    [Test]
    public void findVtmXml() {
        FindVtmResponse response = findVtm(".\\examples\\findVtmRequest.xml");

        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The status is not a success");
        Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The status is not a success");
        Assert.IsTrue(response.getVtms().size() >= 1, "No commented classification found");
    }

    private FindVtmResponse findVtm(string location) {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
        MarshallerHelper marshaller = new MarshallerHelper(typeof(FindVtmRequest), typeof(FindVtmRequest));
        FindVtmRequest request = (FindVtmRequest) marshaller.toObject(inputStream);

        return DicsSessionServiceFactory.getDicsSession().findVtm(request);
    }
}
}