/*
 * Copyright (c) Smals
 */
package be.ehealth.technicalconnector.config.test;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;


/**
 * ConfigurationModule , to be used in testing.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class ConfigurationModuleTester implements ConfigurationModule {

    /**
     * Property used to test
     */
    public static final String TEST_KEY = "configmodule.test.key";

    private static String retrievedKey;

    /**
     
     */
    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        retrievedKey = config.getProperty(TEST_KEY);
    }


    /**
     * @author EHP
     */
    public static String getRetrievedKey() {
        return retrievedKey;
    }


    /**
     
     */
    @Override
    public void unload() throws TechnicalConnectorException {
        //

    }


}
