/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.config.impl;

import java.util.List;

import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.LoggingRule;
import be.fgov.ehealth.technicalconnector.tests.log4j.TestAppender;
import be.fgov.ehealth.technicalconnector.tests.utils.AssertTools;


/**
 * Test to verify that the {@link be.ehealth.technicalconnector.config.ConfigurationModule} {@link ConfigurationModuleVersion}
 *
 * @author EHP
 */
public class ConfigurationModuleVersionTest {

    private TestAppender appender = new TestAppender();

    @Rule
    public LoggingRule logging = LoggingRule.with()
                                            .appender(appender)
                                            .and()
                                            .consoleAppender()
                                            .build();

    @Test
    public void test() throws Exception {
        new ConfigurationModuleVersion().init(null);

        LoggingEvent logEvent = appender.getLastLogEvent(ConfigurationModuleVersion.class);
        Assert.assertNotNull("No log events",logEvent);
        AssertTools.assertLoggingEvent(logEvent, "debug", ConfigurationModuleVersion.class, "\\[CP Content\\].*|\\[JAR with ServiceLoader\\].*");

    }

    @Test
    public void dumpJarFromCP() throws Exception {
        new ConfigurationModuleVersion().dumpJarFromCP();

        LoggingEvent logEvent = appender.getLastLogEvent(ConfigurationModuleVersion.class);
        Assert.assertNotNull("No log events",logEvent);
        AssertTools.assertLoggingEvent(logEvent, "debug", ConfigurationModuleVersion.class, "\\[CP Content\\].*");

    }

    @Test
    public void dumpServiceLoaderFiles() throws Exception {
        appender.getLogEvents().clear();
        new ConfigurationModuleVersion().dumpServiceLoaderFiles();

        LoggingEvent logEvent = appender.getLastLogEvent(ConfigurationModuleVersion.class);
        Assert.assertNotNull("No log events",logEvent);
        AssertTools.assertLoggingEvent(logEvent, "debug", ConfigurationModuleVersion.class, "\\[JAR with ServiceLoader\\].*");

    }
}