/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.ehbox.v3.session;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.businessconnector.ehbox.v3.builders.BuilderFactory;
import be.ehealth.businessconnector.ehbox.v3.session.ServiceFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageRequest;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.ClassRule;
import org.junit.Test;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThrows;

/**
 * @author EHP
 */
public class EhboxV3PublicationErrorIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("olivier").build();


    @Test
    public void invalidBoxId() throws Exception {
        DocumentMessage msg = new DocumentMessage();
        Addressee addressee = new Addressee("74123045193", QualityType.DOCTOR_SSIN);
        msg.getDestinations().add(addressee);
        Document doc = new Document();
        doc.setTitle("body");
        doc.setContent("body-eureka".getBytes());
        doc.setMimeType("text/plain");
        doc.setFilename("body.txt");
        msg.setBody(doc);
        msg.setSender(new Addressee("an invalid box id", QualityType.DOCTOR_SSIN));
        SendMessageRequest request = BuilderFactory.getSendMessageBuilder().buildMessage(msg);

        Exception exception = assertThrows(TechnicalConnectorException.class, () -> {
            ServiceFactory.getEhealthBoxServiceV3().sendMessage(request);
        });

        assertEquals("Error while executing web service call: 810: The specified BoxId is invalid; please verify the data and that you can access it.",
                exception.getMessage());
    }

}
