/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genericasync.helper;

import be.cin.nip.async.generic.ConfirmResponse;
import be.cin.nip.async.generic.TAckResponse;
import be.cin.types.v1.Blob;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedMsgResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedTAckResponse;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorException;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.genericasync.helper.CommonAsyncService;
import be.ehealth.businessconnector.genericasync.helper.GetHelper;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import java.util.HashMap;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultCommonAsyncService
implements CommonAsyncService {
    private GetHelper getHelper;

    public DefaultCommonAsyncService(String projectName) {
        this.getHelper = new GetHelper(projectName);
    }

    @Override
    public ConfirmResponse confirmAll(ProcessedGetResponse getResponse) throws ConnectorException {
        return this.getHelper.confirmAll(getResponse);
    }

    @Override
    public ConfirmResponse confirmAllTAcks(ProcessedGetResponse getResponse) throws ConnectorException {
        return this.getHelper.confirmWithTAckReferences(getResponse);
    }

    @Override
    public ConfirmResponse confirmAllMessages(ProcessedGetResponse getResponse) throws ConnectorException {
        return this.getHelper.confirmWithMessageReferences(getResponse);
    }

    @Override
    public ConfirmResponse confirmTAck(ProcessedTAckResponse tAckResponse) throws ConnectorException {
        return this.getHelper.confirmTAckWithReference(tAckResponse);
    }

    @Override
    public ConfirmResponse confirmMessage(ProcessedMsgResponse msgResponse) throws ConnectorException {
        return this.getHelper.confirmMessageWithReference(msgResponse);
    }

    @Override
    public SignatureVerificationResult validateXadesTWithManifest(TAckResponse tAckResponse, Blob postedBlob, byte[] xadesT) throws GenAsyncBusinessConnectorException {
        Validate.notNull((Object)tAckResponse);
        Validate.notNull((Object)postedBlob);
        Validate.notNull((Object)xadesT);
        Element blobElement = ConnectorXmlUtils.toDocument((Object)postedBlob).getDocumentElement();
        Document signedContent = ConnectorXmlUtils.toDocument((Object)tAckResponse);
        signedContent.getFirstChild().appendChild(signedContent.importNode(blobElement, true));
        byte[] signedByteArray = ConnectorXmlUtils.toByteArray((Node)signedContent);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("followNestedManifest", true);
        try {
            return SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES_T).verify(signedByteArray, xadesT, options);
        }
        catch (TechnicalConnectorException e) {
            throw new GenAsyncBusinessConnectorException(GenAsyncBusinessConnectorExceptionValues.SIGNATURE_VALIDATION_ERROR, e, e.getMessage());
        }
    }
}

