/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderAbstract;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderException;
import be.fgov.ehealth.etee.crypto.status.CMSErrorType;
import be.fgov.ehealth.etee.crypto.utils.Iterables;
import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CMSStreamReader
extends CMSReaderAbstract<InputStream> {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(CMSStreamReader.class);
    private CMSSignedDataParser cmsSignedDataParser;

    CMSStreamReader() {
    }

    @Override
    public void read(CMSMessageContext<InputStream> msgContext) throws CMSReaderException {
        this.initParser(msgContext);
        super.read(msgContext);
    }

    @Override
    public void readSignedContent(CMSMessageContext<InputStream> msgContext) throws CMSReaderException {
        this.initParser(msgContext);
        LOGGER.debug("Reading the signed content from the Signed-Data.");
        if (msgContext.getContentStream() == null) {
            CMSTypedStream signedContent = this.cmsSignedDataParser.getSignedContent();
            if (signedContent != null) {
                msgContext.setContentStream(signedContent.getContentStream());
            } else {
                throw new CMSReaderException(CMSErrorType.CONTENT_MISSING);
            }
        }
    }

    @Override
    public void readSignerInformation(CMSMessageContext<InputStream> msgContext) throws CMSReaderException {
        if (msgContext.getSignerInformation() == null) {
            try {
                Streams.drain(this.cmsSignedDataParser.getSignedContent());
                SignerInformationStore informationStore = this.cmsSignedDataParser.getSignerInfos();
                if (informationStore == null) {
                    throw new CMSReaderException(CMSErrorType.NO_SIGNER_INFOS);
                }
                if (informationStore.getSigners().size() != 1) {
                    throw new CMSReaderException(CMSErrorType.MORE_THAN_1_SIGNER_INFO);
                }
                SignerInformation signerInfo = (SignerInformation)Iterables.first(informationStore.getSigners());
                LOGGER.debug("SignerInfo [Issuer=" + signerInfo.getSID().getIssuer() + ", SerialNumber=" + signerInfo.getSID().getSerialNumber() + ", SubjectKeyIdentifier=" + Arrays.toString(signerInfo.getSID().getSubjectKeyIdentifier()));
                msgContext.setSignerInformation(signerInfo);
            }
            catch (CMSException e) {
                throw new CMSReaderException(CMSErrorType.PARSE_ERROR, (Exception)((Object)e));
            }
        }
    }

    @Override
    public void readCertificates(CMSMessageContext<InputStream> msgContext) throws CMSReaderException {
        if (msgContext.getCertificateStore() == null) {
            try {
                Store store = this.cmsSignedDataParser.getCertificates();
                msgContext.setCertificateStore((Store<X509CertificateHolder>)store);
                msgContext.getCertificateChain().addAll(this.extractCertificateChain((Store<X509CertificateHolder>)store));
            }
            catch (Exception e) {
                throw new CMSReaderException(CMSErrorType.INCORRECTLY_ENCODED_CERTIFICATES, e);
            }
        }
    }

    private void initParser(CMSMessageContext<InputStream> msgContext) throws CMSReaderException {
        if (this.cmsSignedDataParser == null) {
            try {
                this.cmsSignedDataParser = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().build(), (InputStream)new BufferedInputStream(msgContext.getMessage(), 4096));
            }
            catch (Exception e) {
                throw new CMSReaderException(CMSErrorType.PARSE_ERROR, e);
            }
        }
    }
}

