/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehbox.v3.builders;

import be.ehealth.businessconnector.ehbox.v3.builders.ConsultationMessageBuilder;
import be.ehealth.businessconnector.ehbox.v3.builders.RequestBuilder;
import be.ehealth.businessconnector.ehbox.v3.builders.SendMessageBuilder;
import be.ehealth.businessconnector.ehbox.v3.builders.impl.ConsultationMessageBuilderImpl;
import be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl;
import be.ehealth.businessconnector.ehbox.v3.builders.impl.SendMessageBuilderImpl;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;

public final class BuilderFactory
implements SessionServiceWithCache {
    private static volatile SendMessageBuilder sendMessageBuilder;
    private static volatile ConsultationMessageBuilder consultationMessageBuilder;
    private static volatile RequestBuilder requestBuilder;
    private static volatile BuilderFactory instance;
    private static Object mutexSendBuilder;
    private static Object mutexConsBuilder;
    private static Object mutexReqBuilder;
    private static Object mutexBuilderFactory;

    private BuilderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendMessageBuilder getSendMessageBuilder() throws TechnicalConnectorException {
        BuilderFactory.init();
        if (sendMessageBuilder == null) {
            Object object = mutexSendBuilder;
            synchronized (object) {
                if (sendMessageBuilder == null) {
                    sendMessageBuilder = new SendMessageBuilderImpl(KeyDepotManagerFactory.getKeyDepotManager());
                }
            }
        }
        return sendMessageBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsultationMessageBuilder getConsultationMessageBuilder() throws TechnicalConnectorException {
        BuilderFactory.init();
        if (consultationMessageBuilder == null) {
            Object object = mutexConsBuilder;
            synchronized (object) {
                if (consultationMessageBuilder == null) {
                    consultationMessageBuilder = new ConsultationMessageBuilderImpl();
                }
            }
        }
        return consultationMessageBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestBuilder getRequestBuilder() throws TechnicalConnectorException {
        BuilderFactory.init();
        if (requestBuilder == null) {
            Object object = mutexReqBuilder;
            synchronized (object) {
                if (requestBuilder == null) {
                    requestBuilder = new RequestBuilderImpl();
                }
            }
        }
        return requestBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (instance == null) {
            Object object = mutexBuilderFactory;
            synchronized (object) {
                if (instance == null) {
                    instance = new BuilderFactory();
                    Session.getInstance().registerSessionService((SessionServiceWithCache)instance);
                }
            }
        }
    }

    public void flushCache() {
        instance = null;
        sendMessageBuilder = null;
        consultationMessageBuilder = null;
    }

    static {
        mutexSendBuilder = new Object();
        mutexConsBuilder = new Object();
        mutexReqBuilder = new Object();
        mutexBuilderFactory = new Object();
    }
}

