/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.session.impl;

import be.ehealth.technicalconnector.beid.BeIDFactory;
import be.ehealth.technicalconnector.cache.Cache;
import be.ehealth.technicalconnector.cache.CacheFactory;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManager;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.service.sts.SAMLTokenFactory;
import be.ehealth.technicalconnector.service.sts.STSService;
import be.ehealth.technicalconnector.service.sts.STSServiceFactory;
import be.ehealth.technicalconnector.service.sts.domain.SAMLAttribute;
import be.ehealth.technicalconnector.service.sts.domain.SAMLAttributeDesignator;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.KeyStoreInfo;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyStoreCredential;
import be.ehealth.technicalconnector.service.sts.utils.SAMLConfigHelper;
import be.ehealth.technicalconnector.service.sts.utils.SAMLHelper;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.session.SessionManager;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;
import be.ehealth.technicalconnector.session.impl.SessionItemImpl;
import be.ehealth.technicalconnector.session.renew.RenewStrategy;
import be.ehealth.technicalconnector.session.renew.RenewStrategyFactory;
import be.ehealth.technicalconnector.utils.CertificateParser;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.ehealth.technicalconnector.utils.KeyStoreManager;
import be.fgov.ehealth.etee.crypto.utils.KeyManager;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class SessionManagerImpl
implements SessionManager {
    public static final String PROP_FETCH_ETK = "sessionmanager.fetch.etk";
    protected static final String AUTHENTICATION_ALIAS = "authentication";
    private static final String EID_SESSION = "session";
    private static final Logger LOG = LoggerFactory.getLogger(SessionManagerImpl.class);
    private static final String PROP_SESSIONMNG_SAMLATTRIBUTEDESIGNATOR = "sessionmanager.samlattributedesignator";
    private static final String PROP_SESSIONMNG_SAMLATTRIBUTE = "sessionmanager.samlattribute";
    private static final String PROP_KEYSTORE_IDNT_NAME = "sessionmanager.identification.keystore";
    private static final String PROP_KEYSTORE_IDNT_ALIAS = "sessionmanager.identification.alias";
    private static final String PROP_KEYSTORE_HOK_NAME = "sessionmanager.holderofkey.keystore";
    private static final String PROP_KEYSTORE_HOK_ALIAS = "sessionmanager.holderofkey.alias";
    private static final String PROP_KEYSTORE_ENC_NAME = "sessionmanager.encryption.keystore";
    private static final String PROP_KEYSTORE_ENC_ALIAS = "sessionmanager.encryption.alias";
    private static final String PROP_VALIDITY_TOKEN = "sessionmanager.validity.token";
    private static final String PROP_DISABLE_EID_PRESENT = "sessionmanager.disable.eidpresent";
    private static final String PROP_DISABLE_EID_DISCOVERY = "sessionmanager.disable.eiddiscovery";
    private static final String PROP_EMPTY_PASSWORD_HOK = "sessionmanager.holderofkey.emptypassword";
    private static final String PROP_EMPTY_PASSWORD_ENCRYPTION = "sessionmanager.encryption.emptypassword";
    private static final long DEFAULT_VALIDITY_TOKEN = 24L;
    private List<SessionServiceWithCache> cacheService = new ArrayList<SessionServiceWithCache>();
    private ConfigValidator config;
    private Cache<String, KeyStore> cache;
    private Semaphore mutex = new Semaphore(1);
    private SessionItem session = new SessionItemImpl();

    private SessionManagerImpl() {
    }

    public static SessionManagerImpl getInstance() {
        return SessionManagerImplSingleton.INSTANCE.getManagerImpl();
    }

    private static TechnicalConnectorException translate(Exception e, String msg) throws TechnicalConnectorException {
        if (e instanceof TechnicalConnectorException) {
            return (TechnicalConnectorException)e;
        }
        LOG.error(e.getClass().getSimpleName() + ": Could not load " + msg + " keys. Reason:" + e.getMessage());
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, "Could not load " + msg + " keys");
    }

    private static void fetchEtk(KeyDepotManager.EncryptionTokenType type, Map<String, PrivateKey> privateKeys, Configuration config) throws TechnicalConnectorException {
        if (config.getBooleanProperty(PROP_FETCH_ETK, Boolean.TRUE).booleanValue()) {
            EncryptionToken etk = null;
            try {
                etk = KeyDepotManagerFactory.getKeyDepotManager().getETK(type);
            }
            catch (Exception e) {
                LOG.warn("Unable to prefetch ETK", (Throwable)e);
            }
            if (etk != null && !privateKeys.containsKey(etk.getCertificate().getSerialNumber().toString(10))) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "The certificate from the ETK don't match with the one in the encryption keystore");
            }
        }
    }

    private static void isEidPresent() throws TechnicalConnectorException {
        if (ConfigFactory.getConfigValidator().getBooleanProperty(PROP_DISABLE_EID_PRESENT, false).booleanValue()) {
            BeIDFactory.getBeIDInfo("eid-present", false);
        }
    }

    private void bootstrap() {
        if (this.config == null || this.cache == null) {
            try {
                this.mutex.acquire();
                if (this.cache == null) {
                    this.bootstrapCache();
                }
                if (this.config == null) {
                    this.bootstrapConfig();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.mutex.release();
            }
        }
    }

    private void bootstrapConfig() {
        this.config = ConfigFactory.getConfigValidatorFor(PROP_SESSIONMNG_SAMLATTRIBUTE, PROP_SESSIONMNG_SAMLATTRIBUTEDESIGNATOR);
    }

    private void bootstrapCache() {
        this.cache = CacheFactory.newInstance(CacheFactory.CacheType.MEMORY, "sessionmanager-keystore", CacheInformation.ExpiryType.NONE, null);
    }

    @Override
    public void loadSession(SAMLToken token, String hokPwd) throws TechnicalConnectorException {
        this.loadSession(token, hokPwd, null);
    }

    @Override
    public void loadSession(SAMLToken token, String hokPwd, String encryptionPwd) throws TechnicalConnectorException {
        this.bootstrap();
        this.session.setHolderOfKeyCredential(token);
        HashMap<String, PrivateKey> hokPrivateKeys = new HashMap<String, PrivateKey>();
        hokPrivateKeys.put(AUTHENTICATION_ALIAS, token.getPrivateKey());
        try {
            if (token.getKeyStore() != null && hokPwd != null) {
                LOG.debug("Trying to add all the private keys of the HOK keystore.");
                Map tempKeys = KeyManager.getDecryptionKeys((KeyStore)token.getKeyStore(), (char[])hokPwd.toCharArray());
                hokPrivateKeys.putAll(tempKeys);
            }
        }
        catch (Exception e) {
            LOG.warn(e.getClass().getSimpleName() + ":" + e.getMessage(), (Throwable)e);
        }
        this.session.setHolderOfKeyPrivateKeys(hokPrivateKeys);
        this.loadEncryptionKeys(encryptionPwd);
        this.session.setSAMLToken(token);
    }

    @Override
    public SessionItem createSessionEidOnly() throws TechnicalConnectorException {
        return this.createSession(null, null);
    }

    @Override
    public SessionItem createSession(String hokPwd) throws TechnicalConnectorException {
        return this.createSession(hokPwd, null);
    }

    @Override
    public SessionItem createSession(String hokPwd, String encryptionPwd) throws TechnicalConnectorException {
        this.bootstrap();
        SessionManagerImpl.isEidPresent();
        this.populateConfigWithEidFields();
        this.loadIdentificationKeys(null, true);
        this.loadHolderOfKeyKeys(hokPwd, true);
        this.loadEncryptionKeys(encryptionPwd, true);
        return this.initSession();
    }

    @Override
    public SessionItem createFallbackSession(String hokPwd) throws TechnicalConnectorException {
        return this.createFallbackSession(hokPwd, null);
    }

    @Override
    public SessionItem createFallbackSession(String hokPwd, String encryptionPwd) throws TechnicalConnectorException {
        return this.createFallbackSession(hokPwd, hokPwd, encryptionPwd);
    }

    @Override
    public SessionItem createFallbackSession(String idnetPwd, String hokPwd, String encryptionPwd) throws TechnicalConnectorException {
        this.bootstrap();
        this.loadIdentificationKeys(idnetPwd, false);
        this.loadHolderOfKeyKeys(hokPwd, false);
        this.loadEncryptionKeys(encryptionPwd, false);
        return this.initSession();
    }

    @Override
    public SessionItem getSession() {
        if (this.session == null) {
            this.session = new SessionItemImpl();
        }
        return this.session;
    }

    @Override
    public void unloadSession() {
        this.session = new SessionItemImpl();
        for (SessionServiceWithCache serviceWithCache : this.cacheService) {
            serviceWithCache.flushCache();
        }
    }

    @Override
    public boolean hasValidSession() throws SessionManagementException {
        LOG.debug("Checking if session exists and if session is valid...");
        if (this.getSession() == null || this.getSession().getSAMLToken() == null) {
            LOG.debug("No Session found");
            return false;
        }
        RenewStrategy renewStrategy = RenewStrategyFactory.get();
        renewStrategy.renew(this.session);
        DateTime end = SAMLHelper.getNotOnOrAfterCondition(this.getSession().getSAMLToken().getAssertion());
        boolean valid = end.isAfterNow();
        LOG.debug("Session found, valid: {}. (Valid until:{})", (Object)valid, (Object)DateUtils.printDateTime((DateTime)end));
        return valid;
    }

    private void loadIdentificationKeys(String pwd, boolean eidonly) throws TechnicalConnectorException {
        char[] password;
        char[] cArray = password = pwd == null ? ArrayUtils.EMPTY_CHAR_ARRAY : pwd.toCharArray();
        if (this.cache.containsKey("identification")) {
            this.session.setHeaderCredential(new KeyStoreCredential(this.cache.get("identification"), this.config.getProperty(PROP_KEYSTORE_IDNT_ALIAS, AUTHENTICATION_ALIAS), pwd));
        } else if (pwd == null && eidonly) {
            this.session.setHeaderCredential(BeIDCredential.getInstance(EID_SESSION, "Authentication"));
        } else {
            if (pwd == null && !this.config.getBooleanProperty("sessionmanager.identification.emptypassword", false).booleanValue()) {
                return;
            }
            try {
                String pathKeystore = this.config.getProperty(PROP_KEYSTORE_IDNT_NAME);
                char[] pwdKeystore = password;
                String privateKeyAlias = this.config.getProperty(PROP_KEYSTORE_IDNT_ALIAS, AUTHENTICATION_ALIAS);
                char[] privateKeyPwd = password;
                KeyStoreInfo ksInfo = new KeyStoreInfo(pathKeystore, pwdKeystore, privateKeyAlias, privateKeyPwd);
                KeyStoreCredential headerCred = new KeyStoreCredential(ksInfo);
                this.session.setHeaderCredential(headerCred);
            }
            catch (Exception e) {
                LOG.error("{} : Could not load HolderOfkey keys. Reason:{}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, "Could not load decryption keys");
            }
        }
    }

    private void loadHolderOfKeyKeys(String pwd, boolean eidonly) throws TechnicalConnectorException {
        char[] password;
        LOG.debug("Loading HolderOfKeyKeys");
        char[] cArray = password = pwd == null ? ArrayUtils.EMPTY_CHAR_ARRAY : pwd.toCharArray();
        if (this.cache.containsKey("holderofkey")) {
            KeyStore hokstore = this.cache.get("holderofkey");
            this.session.setHolderOfKeyCredential(new KeyStoreCredential(hokstore, this.config.getProperty(PROP_KEYSTORE_HOK_ALIAS, AUTHENTICATION_ALIAS), pwd));
            this.session.setHolderOfKeyPrivateKeys(KeyManager.getDecryptionKeys((KeyStore)hokstore, (char[])password));
        } else if (pwd == null && eidonly) {
            BeIDCredential authCredential = BeIDCredential.getInstance(EID_SESSION, "Authentication");
            HashMap<String, PrivateKey> authPK = new HashMap<String, PrivateKey>();
            authPK.put(AUTHENTICATION_ALIAS, authCredential.getPrivateKey());
            this.session.setHolderOfKeyCredential(authCredential);
            this.session.setHolderOfKeyPrivateKeys(authPK);
        } else {
            if (pwd == null && !this.config.getBooleanProperty(PROP_EMPTY_PASSWORD_HOK, false).booleanValue()) {
                return;
            }
            try {
                String pathKeystore = this.config.getProperty(PROP_KEYSTORE_HOK_NAME);
                char[] pwdKeystore = password;
                String privateKeyAlias = this.config.getProperty(PROP_KEYSTORE_HOK_ALIAS, AUTHENTICATION_ALIAS);
                char[] privateKeyPwd = password;
                KeyStoreInfo ksInfo = new KeyStoreInfo(pathKeystore, pwdKeystore, privateKeyAlias, privateKeyPwd);
                KeyStoreManager encryptionKeystoreManager = new KeyStoreManager(ksInfo);
                Map hokPrivateKeys = KeyManager.getDecryptionKeys((KeyStore)encryptionKeystoreManager.getKeyStore(), (char[])ksInfo.getPrivateKeyPassword());
                this.session.setHolderOfKeyCredential(new KeyStoreCredential(ksInfo));
                this.session.setHolderOfKeyPrivateKeys(hokPrivateKeys);
                SessionManagerImpl.fetchEtk(KeyDepotManager.EncryptionTokenType.HOLDER_OF_KEY, hokPrivateKeys, this.config);
            }
            catch (Exception e) {
                throw SessionManagerImpl.translate(e, "HolderOfKey");
            }
        }
    }

    @Override
    public void loadEncryptionKeys(String encryptionPwd) throws TechnicalConnectorException {
        this.loadEncryptionKeys(encryptionPwd, false);
    }

    private void loadEncryptionKeys(String pwd, boolean eidonly) throws TechnicalConnectorException {
        char[] password;
        LOG.debug("Loading EncryptionKeys");
        char[] cArray = password = pwd == null ? ArrayUtils.EMPTY_CHAR_ARRAY : pwd.toCharArray();
        if (this.cache.containsKey("encryption")) {
            KeyStore hokstore = this.cache.get("encryption");
            this.session.setHolderOfKeyCredential(new KeyStoreCredential(hokstore, this.config.getProperty(PROP_KEYSTORE_ENC_ALIAS, AUTHENTICATION_ALIAS), pwd));
            this.session.setHolderOfKeyPrivateKeys(KeyManager.getDecryptionKeys((KeyStore)hokstore, (char[])password));
        } else if (pwd == null && eidonly) {
            BeIDCredential authCredential = BeIDCredential.getInstance(EID_SESSION, "Authentication");
            HashMap<String, PrivateKey> authPK = new HashMap<String, PrivateKey>();
            authPK.put(AUTHENTICATION_ALIAS, authCredential.getPrivateKey());
            this.session.setEncryptionCredential(authCredential);
            this.session.setEncryptionPrivateKeys(authPK);
        } else {
            if (pwd == null && !this.config.getBooleanProperty(PROP_EMPTY_PASSWORD_ENCRYPTION, false).booleanValue()) {
                return;
            }
            try {
                String pathKeystore = this.config.getProperty(PROP_KEYSTORE_ENC_NAME);
                char[] pwdKeystore = password;
                String privateKeyAlias = this.config.getProperty(PROP_KEYSTORE_ENC_ALIAS, AUTHENTICATION_ALIAS);
                char[] privateKeyPwd = password;
                KeyStoreInfo ksInfo = new KeyStoreInfo(pathKeystore, pwdKeystore, privateKeyAlias, privateKeyPwd);
                KeyStoreManager encryptionKeystoreManager = new KeyStoreManager(ksInfo);
                Map encryptionPrivateKeys = KeyManager.getDecryptionKeys((KeyStore)encryptionKeystoreManager.getKeyStore(), (char[])ksInfo.getPrivateKeyPassword());
                this.session.setEncryptionCredential(new KeyStoreCredential(ksInfo));
                this.session.setEncryptionPrivateKeys(encryptionPrivateKeys);
                SessionManagerImpl.fetchEtk(KeyDepotManager.EncryptionTokenType.ENCRYPTION, encryptionPrivateKeys, this.config);
            }
            catch (Exception e) {
                throw SessionManagerImpl.translate(e, "EncrytionKeys");
            }
        }
    }

    @Override
    public void registerSessionService(SessionServiceWithCache serviceWithCache) {
        this.cacheService.add(serviceWithCache);
        RenewStrategy strategy = RenewStrategyFactory.get();
        this.cacheService.add(strategy);
        strategy.register(serviceWithCache);
    }

    private SessionItem initSession() throws TechnicalConnectorException {
        Duration validity = this.config.getDurationProperty(PROP_VALIDITY_TOKEN, this.config.getLongProperty(PROP_VALIDITY_TOKEN, 24L), TimeUnit.HOURS);
        LOG.debug("Requesting SAML-Token from STS...");
        SAMLToken token = this.getToken(validity, this.session.getHeaderCredential(), this.session.getHolderOfKeyCredential());
        LOG.debug("SAML Token received");
        LOG.debug("Loading SAML token into session...");
        this.session.setSAMLToken(token);
        LOG.debug("Session created!");
        LOG.debug("Registering session to RenewStrategy");
        RenewStrategyFactory.get().renew(this.session);
        return this.session;
    }

    protected SAMLToken getToken(Duration validity, Credential headerCredential, Credential bodyCredential) throws TechnicalConnectorException {
        Validate.notNull((Object)headerCredential, (String)"Parameter headerCredential is not nullable", (Object[])new Object[0]);
        Validate.notNull((Object)bodyCredential, (String)"Parameter bodyCredential is not nullable", (Object[])new Object[0]);
        List<SAMLAttributeDesignator> designators = SAMLConfigHelper.getSAMLAttributeDesignators(PROP_SESSIONMNG_SAMLATTRIBUTEDESIGNATOR);
        List<SAMLAttribute> attributes = SAMLConfigHelper.getSAMLAttributes(PROP_SESSIONMNG_SAMLATTRIBUTE);
        STSService sts = STSServiceFactory.getInstance();
        Element assertion = sts.getToken(headerCredential, bodyCredential, attributes, designators, "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key", validity);
        return SAMLTokenFactory.getInstance().createSamlToken(assertion, bodyCredential);
    }

    private void populateConfigWithEidFields() throws TechnicalConnectorException {
        String userInss;
        if (!this.config.getBooleanProperty(PROP_DISABLE_EID_DISCOVERY, false).booleanValue() && StringUtils.isEmpty((CharSequence)(userInss = this.config.getProperty("user.inss")))) {
            String ssin = new CertificateParser(BeIDCredential.getInstance(EID_SESSION, "Authentication").getCertificate()).getId();
            this.config.setProperty("user.inss", ssin);
        }
    }

    @Override
    public void setKeyStore(Map<String, KeyStore> keystores) {
        this.bootstrap();
        this.cache.clear();
        this.cache.putAll(keystores);
    }

    private static enum SessionManagerImplSingleton {
        INSTANCE;

        private volatile SessionManagerImpl manager = new SessionManagerImpl();

        public SessionManagerImpl getManagerImpl() {
            return this.manager;
        }
    }
}

