/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy;

import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.direct.DirectProxy;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.stop.StopEventQueue;

public class ProxyBuilder {
    private Integer localPort;
    private String remoteHost;
    private Integer remotePort;
    private StopEventQueue stopEventQueue = new StopEventQueue();

    public ProxyBuilder withStopEventQueue(StopEventQueue stopEventQueue) {
        this.stopEventQueue = stopEventQueue;
        return this;
    }

    public ProxyBuilder withLocalPort(Integer localPort) {
        this.localPort = localPort;
        return this;
    }

    public ProxyBuilder withDirect(String remoteHost, Integer remotePort) {
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        return this;
    }

    public Proxy build() {
        if (this.localPort != null) {
            if (this.remoteHost != null && this.remotePort != null) {
                return new DirectProxy(this.localPort, this.remoteHost, this.remotePort).withStopEventQueue(this.stopEventQueue);
            }
            return new HttpProxy(this.localPort).withStopEventQueue(this.stopEventQueue);
        }
        throw new IllegalArgumentException("LocalPort must be specified before the proxy is started");
    }
}

