/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.consumer.tlv;

import be.fedict.commons.eid.consumer.DateMask;
import be.fedict.commons.eid.consumer.tlv.DataConvertor;
import be.fedict.commons.eid.consumer.tlv.DataConvertorException;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateOfBirthMaskDataConvertor
implements DataConvertor<DateMask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateOfBirthMaskDataConvertor.class);

    @Override
    public DateMask convert(byte[] value) throws DataConvertorException {
        String dateOfBirthStr;
        try {
            dateOfBirthStr = new String(value, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException uex) {
            throw new DataConvertorException("UTF-8 not supported");
        }
        LOGGER.debug("\"{}\"", (Object)dateOfBirthStr);
        if (dateOfBirthStr.length() == 4) {
            return DateMask.YYYY;
        }
        return DateMask.YYYY_MM_DD;
    }
}

