package be.fgov.ehealth.technicalconnector.services.schematron;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.services.ServiceFactory;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;

public class SchematronValidatorTest {

    @Before
    public void before() {
        LoggingUtils.bootstrap();
    }


    private static SchematronValidationResult validate(String locationBase, boolean isValid) throws Exception {
        SchematronValidator validator = ServiceFactory.getSchematronValidator();
        String expected = ConnectorIOUtils.getResourceAsString(locationBase + ".svrl");
        SchematronValidationResult result = validator.validate(locationBase + ".input", locationBase + ".sch");
        XmlAsserter.assertSimilar(expected, result.getSVRLAsString());
        Assert.assertNotNull(result.getSVRL());
        if (isValid != result.isValid()) {
            Assert.fail("Unexpected result");
        }
        return result;
    }

    @Test
    public void validateDummy() throws Exception {
        validate("/schematron/dummy", false);
    }


}