package be.ehealth.businessconnector.test.testcommons;

import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.RestoreSystemProperties;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;

/**
 * Created by EH053 on 23/03/2017.
 */
public class BusinessSessionRule extends ExternalResource {


    public static TestRule withActiveSession(String location) {
        RuleChain chain = RuleChain
            .outerRule(new RestoreSystemProperties())
            .around(SessionRule.withActiveSession().baseOn(location).build());
        return new BusinessSessionRule(chain);
    }

    private RuleChain ruleChain;

    private BusinessSessionRule(RuleChain ruleChain) {
        this.ruleChain = ruleChain;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return ruleChain.apply(base, description);
    }
}
