/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.etee.impl;

import be.ehealth.technicalconnector.service.sts.security.impl.KeyStoreCredential;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;


/**
 * Integration test for {@link ConnectorOCSPRevocationStatusChecker}.
 *
 * @author EHP
 */
public class ConnectorOCSPRevocationStatusCheckerIntegrationTest {


    @ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession().build();

    /**
     * Tests RevocationStatusChecker with keystore credential (from ehealth certificate)
     */
    @Test
    public void testWithKeyStoreCredential() throws Exception {
        String eHealthCertAlias = rule.getSessionProperty("test.keystore.alias");
        String eHealthCertificate = rule.getSessionProperty("test.keystore.location");
        String eHealthCertPassword = rule.getSessionProperty("test.keystore.password");

        ConnectorRevocationStatusChecker checker = new ConnectorRevocationStatusChecker();
        KeyStoreCredential credential = new KeyStoreCredential(eHealthCertificate, eHealthCertAlias, eHealthCertPassword);
        boolean isRevoked = checker.isRevoked(credential.getCertificate());
        Assert.assertFalse(isRevoked);
    }

}
