/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.dicsv4.session;

import java.util.HashMap;
import java.util.Map;

import be.ehealth.businessconnector.dicsv4.session.DicsSessionServiceFactory;
import be.fgov.ehealth.dics.protocol.v4.FindNonMedicinalProductRequest;
import be.fgov.ehealth.dics.protocol.v4.FindNonMedicinalProductResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.businessconnector.dicsv4.exception.DicsDataNotFoundException;
import be.ehealth.businessconnector.dicsv4.exception.DicsException;
import be.ehealth.businessconnector.test.testcommons.utils.FileTestUtils;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.dics.protocol.v4.FindAmpRequest;
import be.fgov.ehealth.dics.protocol.v4.FindAmpResponse;
import be.fgov.ehealth.dics.protocol.v4.FindCommentedClassificationRequest;
import be.fgov.ehealth.dics.protocol.v4.FindCommentedClassificationResponse;
import be.fgov.ehealth.dics.protocol.v4.FindCompanyRequest;
import be.fgov.ehealth.dics.protocol.v4.FindCompanyResponse;
import be.fgov.ehealth.dics.protocol.v4.FindCompoundingFormulaRequest;
import be.fgov.ehealth.dics.protocol.v4.FindCompoundingFormulaResponse;
import be.fgov.ehealth.dics.protocol.v4.FindCompoundingIngredientRequest;
import be.fgov.ehealth.dics.protocol.v4.FindCompoundingIngredientResponse;
import be.fgov.ehealth.dics.protocol.v4.FindLegislationTextRequest;
import be.fgov.ehealth.dics.protocol.v4.FindLegislationTextResponse;
import be.fgov.ehealth.dics.protocol.v4.FindReferencesRequest;
import be.fgov.ehealth.dics.protocol.v4.FindReferencesResponse;
import be.fgov.ehealth.dics.protocol.v4.FindReimbursementRequest;
import be.fgov.ehealth.dics.protocol.v4.FindReimbursementResponse;
import be.fgov.ehealth.dics.protocol.v4.FindVmpGroupRequest;
import be.fgov.ehealth.dics.protocol.v4.FindVmpGroupResponse;
import be.fgov.ehealth.dics.protocol.v4.FindVmpRequest;
import be.fgov.ehealth.dics.protocol.v4.FindVmpResponse;
import be.fgov.ehealth.dics.protocol.v4.FindVtmRequest;
import be.fgov.ehealth.dics.protocol.v4.FindVtmResponse;
import be.fgov.ehealth.dics.protocol.v4.GetListOfActualMedicinalProductPackagesRequest;
import be.fgov.ehealth.dics.protocol.v4.GetListOfActualMedicinalProductPackagesResponse;
import be.fgov.ehealth.dics.protocol.v4.GetListOfActualMedicinalProductsRequest;
import be.fgov.ehealth.dics.protocol.v4.GetListOfActualMedicinalProductsResponse;
import be.fgov.ehealth.dics.protocol.v4.GetListOfVirtualMedicinalProductsRequest;
import be.fgov.ehealth.dics.protocol.v4.GetListOfVirtualMedicinalProductsResponse;
import be.fgov.ehealth.dics.protocol.v4.GetListOfVmpGroupsRequest;
import be.fgov.ehealth.dics.protocol.v4.GetListOfVmpGroupsResponse;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;

/**
 * Integration tests for Dics V4.
 * 
 * @author EHP
 */
public final class DicsIntegrationTest {

    @ClassRule
    public static SessionRule sessionRule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.dicsv4.test.properties").build();

//    @BeforeClass
//    public static void setup() {
//        ConfigFactory.getConfigValidator().setProperty("endpoint.dicsv4", "https://services-int.ehealth.fgov.be/Dics/v4");
//    }

    @Test
    public void findAmpTestXml() throws Exception {
        FindAmpResponse response = findAmpTest("/examples/request/findAmpRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findAmpResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findCompanyXml() throws Exception {
        FindCompanyResponse response = findCompany("/examples/request/findCompanyRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findCompanyResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findReferencesXml() throws Exception {
        FindReferencesResponse response = findReferences("/examples/request/findReferencesRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findReferencesResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findVmpGroupXml() throws Exception {
        FindVmpGroupResponse response = findVmpGroup("/examples/request/findVmpGroupRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVmpGroupResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findVmpXml() throws Exception {
        FindVmpResponse response = findVmp("/examples/request/findVmpRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVmpResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findVtmXml() throws Exception {
        FindVtmResponse response = findVtm("/examples/request/findVtmRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVtmResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findNonMedicinalProductTest() throws Exception {
        FindNonMedicinalProductResponse response = findNonMedicinalProduct("/examples/request/findNonMedicinalProductRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findNonMedicinalProductResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void getListOfActualMedicinalProductPackagesXml() throws Exception {
        GetListOfActualMedicinalProductPackagesResponse response = getListOfActualMedicinalProductPackages("/examples/request/GetListOfActualMedicinalProductPackagesRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/GetListOfActualMedicinalProductPackagesResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void getListOfActualMedicinalProductsXml() throws Exception {
        GetListOfActualMedicinalProductsResponse response = getListOfActualMedicinalProducts("/examples/request/GetListOfActualMedicinalProductsRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/GetListOfActualMedicinalProductsResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void getListOfVirtualMedicinalProductsXml() throws Exception {
        GetListOfVirtualMedicinalProductsResponse response = getListOfVirtualMedicinalProducts("/examples/request/GetListOfVirtualMedicinalProductsRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/GetListOfVirtualMedicinalProductsResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void getListOfVmpGroupsXml() throws Exception {
        GetListOfVmpGroupsResponse response = getListOfVmpGroups("/examples/request/GetListOfVmpGroupsRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/GetListOfVmpGroupsResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findAmpTestXmlNoDataFound() throws Exception {
        try {
            findAmpTest("/examples/request/findAmpRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findAmpResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findCommentedClassificationXmlNoDataFound() throws Exception {
        try {
            findCommentedClassification("/examples/request/findCommentedClassificationRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findCommentedClassificationResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findCompanyXmlNoDataFound() throws Exception {
        try {
            findCompany("/examples/request/findCompanyRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findCompanyResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findFormulaXmlNoDataFound() throws Exception {
        try {
            findFormula("/examples/request/findFormulaRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findFormulaResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findIngredientXmlNoDataFound() throws Exception {
        try {
            findIngredient("/examples/request/findIngredientRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findIngredientResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findLegislationXmlNoDataFound() throws Exception {
        try {
            findLegislation("/examples/request/findLegislationTextRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findLegislationTextResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findReimboursementXmlNoDataFound() throws Exception {
        try {
            findReimboursement("/examples/request/findReimboursementRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findReimboursementResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findVmpGroupXmlNoDataFound() throws Exception {
        try {
            findVmpGroup("/examples/request/findVmpGroupRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVmpGroupResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findVmpXmlNoDataFound() throws Exception {
        try {
            findVmp("/examples/request/findVmpRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVmpResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void findVtmXmlNoDataFound() throws Exception {
        try {
            findVtm("/examples/request/findVtmRequest-noDataFound.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVtmResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    @Test
    public void invalidInput() throws Exception {
        try {
            findFormula("/examples/request/InvalidInputRequest.xml");
            Assert.fail("This test should send an exception");
        } catch (DicsException e) {
            Assert.assertTrue("No anomaly found", e.getAnomalies().size() > 0);
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/InvalidInputResponse.xml"), 
                ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    private FindAmpResponse findAmpTest(String location) throws Exception {
        FindAmpRequest request = transformRequest(location, FindAmpRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findAmp(request);
    }

    private FindCommentedClassificationResponse findCommentedClassification(String location) throws Exception {
        FindCommentedClassificationRequest request = transformRequest(location, FindCommentedClassificationRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findCommentedClassification(request);
    }

    private FindCompanyResponse findCompany(String location) throws Exception {
        FindCompanyRequest request = transformRequest(location, FindCompanyRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findCompany(request);
    }

    private FindCompoundingFormulaResponse findFormula(String location) throws Exception {
        FindCompoundingFormulaRequest request = transformRequest(location, FindCompoundingFormulaRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findFormula(request);
    }

    private FindCompoundingIngredientResponse findIngredient(String location) throws Exception {
        FindCompoundingIngredientRequest request = transformRequest(location, FindCompoundingIngredientRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findIngredient(request);
    }

    private FindLegislationTextResponse findLegislation(String location) throws Exception {
        FindLegislationTextRequest request = transformRequest(location, FindLegislationTextRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findLegislationText(request);
    }

    private FindReferencesResponse findReferences(String location) throws Exception {
        FindReferencesRequest request = transformRequest(location, FindReferencesRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findReferences(request);
    }

    private FindReimbursementResponse findReimboursement(String location) throws Exception {
        FindReimbursementRequest request = transformRequest(location, FindReimbursementRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findReimbursement(request);
    }

    private FindVmpGroupResponse findVmpGroup(String location) throws Exception {
        FindVmpGroupRequest request = transformRequest(location, FindVmpGroupRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findVmpGroup(request);
    }

    private FindVtmResponse findVtm(String location) throws Exception {
        FindVtmRequest request = transformRequest(location, FindVtmRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findVtm(request);
    }

    private FindVmpResponse findVmp(String location) throws Exception {
        FindVmpRequest request = transformRequest(location, FindVmpRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findVmp(request);
    }

    private FindNonMedicinalProductResponse findNonMedicinalProduct(String location) throws Exception {
        FindNonMedicinalProductRequest request = transformRequest(location, FindNonMedicinalProductRequest.class);
        return DicsSessionServiceFactory.getDicsSession().findNonMedicinalProduct(request);
    }

    private GetListOfActualMedicinalProductPackagesResponse getListOfActualMedicinalProductPackages(String location) throws Exception {
        GetListOfActualMedicinalProductPackagesRequest request = transformRequest(location, GetListOfActualMedicinalProductPackagesRequest.class);

        return DicsSessionServiceFactory.getDicsSession().getListOfActualMedicinalProductPackages(request);
    }

    private GetListOfActualMedicinalProductsResponse getListOfActualMedicinalProducts(String location) throws Exception {
        GetListOfActualMedicinalProductsRequest request = transformRequest(location, GetListOfActualMedicinalProductsRequest.class);

        return DicsSessionServiceFactory.getDicsSession().getListOfActualMedicinalProducts(request);
    }

    private GetListOfVirtualMedicinalProductsResponse getListOfVirtualMedicinalProducts(String location) throws Exception {
        GetListOfVirtualMedicinalProductsRequest request = transformRequest(location, GetListOfVirtualMedicinalProductsRequest.class);

        return DicsSessionServiceFactory.getDicsSession().getListOfVirtualMedicinalProducts(request);
    }

    private GetListOfVmpGroupsResponse getListOfVmpGroups(String location) throws Exception {
        GetListOfVmpGroupsRequest request = transformRequest(location, GetListOfVmpGroupsRequest.class);

        return DicsSessionServiceFactory.getDicsSession().getListOfVmpGroups(request);
    }

    private <T> T transformRequest(String fileLocation, Class<T> clazz) throws Exception {
        Map<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("issueInstant", DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'+02:00'").print(new DateTime()));
        velocityContext.put("requestId", IdGeneratorFactory.getIdGenerator("uuid").generateId());
        velocityContext.put("currentDate", DateTimeFormat.forPattern("yyyy-MM-dd").print(new DateTime()));
        velocityContext.put("generatedChars1", RandomStringUtils.randomAlphabetic(10).toLowerCase());
        velocityContext.put("generatedChars2", RandomStringUtils.randomAlphabetic(10).toLowerCase());

        return FileTestUtils.toObject(velocityContext, fileLocation, clazz);
    }
}

