/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.policies.SignatureLayer;
import be.fgov.ehealth.etee.crypto.status.NotificationError;

enum SignedDataNotification {
    SIGNATURE_ALGORITHM_UNAUTHORIZED(NotificationError.INNER_SIGNATURE_ALGORITHM_UNAUTHORIZED, NotificationError.OUTER_SIGNATURE_ALGORITHM_UNAUTHORIZED),
    SIGNATURE_DIGEST_ALGORITHM_UNAUTHORIZED(NotificationError.INNER_SIGNATURE_DIGEST_ALGORITHM_UNAUTHORIZED, NotificationError.OUTER_SIGNATURE_DIGEST_ALGORITHM_UNAUTHORIZED),
    SIGNATURE_KEY_LENGTH_UNAUTHORIZED(NotificationError.INNER_SIGNATURE_KEY_LENGTH_UNAUTHORIZED, NotificationError.OUTER_SIGNATURE_KEY_LENGTH_UNAUTHORIZED),
    CERTIFICATE_EXPECTED_BUT_NOT_PRESENT(NotificationError.INNER_CERTIFICATE_EXPECTED_BUT_NOT_PRESENT, NotificationError.OUTER_CERTIFICATE_EXPECTED_BUT_NOT_PRESENT),
    CERTIFICATE_HAS_INVALID_KEYUSAGE(NotificationError.INNER_CERTIFICATE_HAS_INVALID_KEYUSAGE, NotificationError.OUTER_CERTIFICATE_HAS_INVALID_KEYUSAGE),
    CERTIFICATE_REVOKED(NotificationError.INNER_CERTIFICATE_REVOKED, NotificationError.OUTER_CERTIFICATE_REVOKED),
    CERTIFICATE_STATUS_UNKNOWN(NotificationError.INNER_CERTIFICATE_STATUS_UNKNOWN, NotificationError.OUTER_CERTIFICATE_STATUS_UNKNOWN),
    CERTIFICATE_EXPIRED(NotificationError.INNER_CERTIFICATE_EXPIRED, NotificationError.OUTER_CERTIFICATE_EXPIRED),
    CERTIFICATE_NOT_YET_VALID(NotificationError.INNER_CERTIFICATE_NOT_YET_VALID, NotificationError.OUTER_CERTIFICATE_NOT_YET_VALID),
    CERTIFICATE_CHAIN_NOT_TRUSTED(NotificationError.INNER_CERTIFICATE_CHAIN_NOT_TRUSTED, NotificationError.OUTER_CERTIFICATE_CHAIN_NOT_TRUSTED),
    SIGNATURE_DOES_NOT_MATCH_CERTIFICATE(NotificationError.INNER_SIGNATURE_DOES_NOT_MATCH_SIGNATURE_CERTIFICATE, NotificationError.OUTER_SIGNATURE_DOES_NOT_MATCH_AUTHENTICATION_CERTIFICATE),
    SIGNER_NOT_ALLOWED(NotificationError.SIGNATURE_CERTIFICATE_NOT_IN_LIST_EXPECTED_SIGNERS, NotificationError.AUTHENTICATION_CERTIFICATE_NOT_IN_LIST_EXPECTED_SIGNERS),
    SIGNATURE_COULD_NOT_BE_VERIFIED(NotificationError.INNER_SIGNATURE_COULD_NOT_BE_VERIFIED, NotificationError.OUTER_SIGNATURE_COULD_NOT_BE_VERIFIED),
    SUBJECT_KEY_IDENTIFIER_EXPECTED_BUT_NOT_PRESENT(NotificationError.INNER_SUBJECT_KEY_IDENTIFIER_EXPECTED_BUT_NOT_PRESENT, NotificationError.OUTER_SUBJECT_KEY_IDENTIFIER_EXPECTED_BUT_NOT_PRESENT);

    private NotificationError inner;
    private NotificationError outer;

    private SignedDataNotification(NotificationError inner, NotificationError outer) {
        this.inner = inner;
        this.outer = outer;
    }

    public NotificationError get(SignatureLayer layer) {
        return SignatureLayer.INNER.equals((Object)layer) ? this.inner : this.outer;
    }
}

