/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;

public class DerbyDbSupport
extends DbSupport {
    public DerbyDbSupport() {
        super("derby");
    }

    @Override
    public Set<String> getTableNames() {
        return this.getSQLHandler().getItemsAsStringSet("select t.TABLENAME from SYS.SYSTABLES t, SYS.SYSSCHEMAS  s where t.TABLETYPE = 'T' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select c.COLUMNNAME from SYS.SYSCOLUMNS c, SYS.SYSTABLES t, SYS.SYSSCHEMAS s where c.REFERENCEID = t.TABLEID and t.TABLENAME = '" + tableName + "' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select t.TABLENAME from SYS.SYSTABLES t, SYS.SYSSCHEMAS s where t.TABLETYPE = 'V' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getSynonymNames() {
        return this.getSQLHandler().getItemsAsStringSet("select t.TABLENAME from SYS.SYSTABLES t, SYS.SYSSCHEMAS s where t.TABLETYPE = 'A' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getTriggerNames() {
        return this.getSQLHandler().getItemsAsStringSet("select t.TRIGGERNAME from SYS.SYSTRIGGERS t, SYS.SYSSCHEMAS s where t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getIdentityColumnNames(String tableName) {
        return this.getPrimaryKeyColumnNames(tableName);
    }

    @Override
    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(identityColumnName) + " RESTART WITH " + identityValue);
    }

    @Override
    public void disableReferentialConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(tableName);
        }
    }

    protected void disableReferentialConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select c.CONSTRAINTNAME from SYS.SYSCONSTRAINTS c, SYS.SYSTABLES t, SYS.SYSSCHEMAS s where c.TYPE = 'F' AND c.TABLEID = t.TABLEID  AND t.TABLENAME = '" + tableName + "' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
        }
    }

    @Override
    public void disableValueConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableValueConstraints(tableName);
        }
    }

    protected void disableValueConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select c.CONSTRAINTNAME from SYS.SYSCONSTRAINTS c, SYS.SYSTABLES t, SYS.SYSSCHEMAS s where c.TYPE in ('U', 'C') AND c.TABLEID = t.TABLEID  AND t.TABLENAME = '" + tableName + "' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
        }
        Set<String> primaryKeyColumnNames = this.getPrimaryKeyColumnNames(tableName);
        Set<String> notNullColumnNames = this.getNotNullColummnNames(tableName);
        for (String notNullColumnName : notNullColumnNames) {
            if (primaryKeyColumnNames.contains(notNullColumnName)) continue;
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(notNullColumnName) + " NULL");
        }
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    protected Set<String> getPrimaryKeyColumnNames(String tableName) {
        HashSet<String> hashSet;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getPrimaryKeys(null, this.getSchemaName(), tableName);
            HashSet<String> result = new HashSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(4));
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new UnitilsException("Error while querying for Derby primary keys for table name: " + tableName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, null, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, null, resultSet);
        return hashSet;
    }

    protected Set<String> getNotNullColummnNames(String tableName) {
        HashSet<String> hashSet;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, this.getSchemaName(), tableName, "%");
            HashSet<String> result = new HashSet<String>();
            while (resultSet.next()) {
                if (resultSet.getInt(11) != 0) continue;
                result.add(resultSet.getString(4));
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new UnitilsException("Error while querying for Derby primary keys for table name: " + tableName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, null, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, null, resultSet);
        return hashSet;
    }
}

