package be.ehealth.businessconnector.consultrnv2.session;

import be.ehealth.businessconnector.consultrnv2.session.support.RequestTransformer;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.SoaErrorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.rn.personservice.protocol.v1.SearchPersonBySsinRequest;
import be.fgov.ehealth.rn.personservice.protocol.v1.SearchPersonBySsinResponse;
import be.fgov.ehealth.rn.personservice.protocol.v1.SearchPersonPhoneticallyRequest;
import be.fgov.ehealth.rn.personservice.protocol.v1.SearchPersonPhoneticallyResponse;
import be.fgov.ehealth.rn.registries.commons.v1.DetailedStatusType;
import be.fgov.ehealth.rn.registries.commons.v1.ValidationErrors;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.w3c.dom.Element;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ConsultrnSessionPersonServiceIntegrationTest {

    private static final RequestTransformer TRANSFORMER = new RequestTransformer();

    @ClassRule
    public static SessionRule sessionRule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.consultrnv2.test.properties").build();

    @BeforeClass
    public static void setup() {
//        ConfigFactory.getConfigValidator().setProperty("endpoint.consultrnv2.personservice", "https://services-int.ehealth.fgov.be/rnconsult/PersonService/v1");
        ConfigFactory.getConfigValidator().setProperty("endpoint.consultrnv2.personservice", "https://preview-intr2.api.ehealth.fgov.be/rnconsult/PersonService/v1");
    }

    @Test
    public void testSearchPersonBySsin() throws Exception {
        SearchPersonBySsinRequest request = TRANSFORMER.transform("/examples/request/searchPersonBySsinRequest.xml", SearchPersonBySsinRequest.class);
        SearchPersonBySsinResponse response = ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonBySsin(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/searchPersonBySsinResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void testSearchPersonBySsinWithError() throws Exception {
        try {
            SearchPersonBySsinRequest request = TRANSFORMER.transform("/examples/request/searchPersonBySsinRequest-error.xml", SearchPersonBySsinRequest.class);
            ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonBySsin(request);
        } catch (SoaErrorException see) {
            SearchPersonBySsinResponse response = (SearchPersonBySsinResponse) see.getResponseTypeV2();
            Assert.assertEquals("The applicationId is malformed", response.getStatus().getStatusMessage());
        }
    }

    @Test
    public void testSearchPersonPhonetically() throws Exception {
        SearchPersonPhoneticallyRequest request = TRANSFORMER.transform("/examples/request/searchPersonPhoneticallyRequest.xml", SearchPersonPhoneticallyRequest.class);
        SearchPersonPhoneticallyResponse response = ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonPhonetically(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/searchPersonPhoneticallyResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void testSearchPersonPhoneticallyWithError() throws Exception {
        try {
            SearchPersonPhoneticallyRequest request = TRANSFORMER.transform("/examples/request/searchPersonPhoneticallyRequest-error.xml", SearchPersonPhoneticallyRequest.class);
            ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonPhonetically(request);
        } catch (SoaErrorException see) {
            SearchPersonPhoneticallyResponse response = (SearchPersonPhoneticallyResponse) see.getResponseTypeV2();
            Assert.assertEquals("Algorithm for given name doesn’t exists", response.getStatus().getStatusMessage());
        }
    }

    @Test
    public void testSearchPersonPhoneticallyWithValidationError() throws Exception {
        try {
            SearchPersonPhoneticallyRequest request = TRANSFORMER.transform("/examples/request/searchPersonPhoneticallyRequest-validationError.xml", SearchPersonPhoneticallyRequest.class);
            ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonPhonetically(request);
        } catch (SoaErrorException see) {
            SearchPersonPhoneticallyResponse response = (SearchPersonPhoneticallyResponse) see.getResponseTypeV2();
            Assert.assertEquals("Business validation error", response.getStatus().getStatusMessage());

            Element elt = (Element) response.getStatus().getStatusDetail().getAnies().get(0);
            JAXBContext context = JaxbContextFactory.getJaxbContextForClass(ValidationErrors.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            ValidationErrors errors = (ValidationErrors) unmarshaller.unmarshal(elt);

            DetailedStatusType validationError = errors.getValidationErrors().get(0);
            Assert.assertEquals("900021", validationError.getCode());
            Assert.assertEquals("Invalid country code", validationError.getDescription());
        }
    }

}
