package be.ehealth.technicalconnector.handler;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.RetryNextEndpointException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.ws.impl.SOAPMessageContextImpl;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;

public class MessageLevelRetryHandlerTest {

    public static void before() {
        LoggingUtils.bootstrap();
    }

    @Test
    public void soapFaultSwitchDesActivated() throws Exception {

        ConfigFactory.getConfigValidator().setProperty(MessageLevelRetryHandler.PROP_MESSAGELEVEL_RETRY_ACTIVATED,"false");

        String body = ConnectorIOUtils.getResourceAsString("/examples/soap/soapFault.SystemError.SOA01001.xml");

        SOAPMessageContext context = generate(body);

        boolean result = new MessageLevelRetryHandler().handleMessage(context);
        Assert.assertTrue(result);
    }

    @Test(expected = RetryNextEndpointException.class)
    public void soapFaultSwitchActivatedTriggered() throws Exception {
        ConfigFactory.getConfigValidator().setProperty(MessageLevelRetryHandler.PROP_MESSAGELEVEL_RETRY_ACTIVATED,"true");

        String body = ConnectorIOUtils.getResourceAsString("/examples/soap/soapFault.SystemError.SOA01001.xml");

        SOAPMessageContext context = generate(body);

        new MessageLevelRetryHandler().handleMessage(context);


    }


    @Test
    public void soapFaultSwitchActivatedNotTriggered() throws Exception {

        ConfigFactory.getConfigValidator().setProperty(MessageLevelRetryHandler.PROP_MESSAGELEVEL_RETRY_ACTIVATED,"true");

        String body = ConnectorIOUtils.getResourceAsString("/examples/soap/soapFault.SystemError.SOA03006.xml");

        SOAPMessageContext context = generate(body);

        boolean result = new MessageLevelRetryHandler().handleMessage(context);
        Assert.assertTrue(result);
    }

    private static SOAPMessageContext generate(String body) throws SOAPException, TechnicalConnectorException {
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage soapMessage = mf.createMessage();
        soapMessage.getSOAPBody()
                   .addDocument(ConnectorXmlUtils.toDocument(body));

        SOAPMessageContext context = new SOAPMessageContextImpl(soapMessage);

        context.put(MessageContext.MESSAGE_OUTBOUND_PROPERTY, Boolean.FALSE);
        return context;
    }
}