/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sso.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.enumeration.SsoProfile;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.idgenerator.IdGenerator;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.service.sso.BrowserHandler;
import be.ehealth.technicalconnector.service.sso.SingleSignOnService;
import be.ehealth.technicalconnector.service.sso.impl.DefaultBrowserHandler;
import be.ehealth.technicalconnector.session.AbstractSessionServiceWithCache;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.ws.ServiceFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bouncycastle.util.encoders.Base64;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SingleSignOnServiceImpl
extends AbstractSessionServiceWithCache
implements SingleSignOnService {
    private static final String PROP_SSO_AUTODISCOVERY_ENABLED = "be.ehealth.technicalconnector.service.sso.autodiscovery.enabled";
    public static final String PROP_ENDPOINT_STS_SSO = "endpoint.sts.sso";
    public static final String PROP_ENDPOINT_IDP_SAML2_POST = "endpoint.idp.saml2.post";
    public static final String PROP_ENDPOINT_IDP_SAML2_ARTIFACT = "endpoint.idp.saml2.artifact";
    public static final String PROP_DEFAULT_BROWSER_HANDLER = "be.ehealth.technicalconnector.service.sso.browserhandler.default";
    private static final Logger LOG = LoggerFactory.getLogger(SingleSignOnServiceImpl.class);
    private IdGenerator idGenerator;
    private ConfigValidator config;
    private BrowserHandler browserHandler;

    public SingleSignOnServiceImpl() {
        try {
            this.idGenerator = IdGeneratorFactory.getIdGenerator("xsid");
            this.config = ConfigFactory.getConfigValidator();
            this.browserHandler = (BrowserHandler)new ConfigurableFactoryHelper(PROP_DEFAULT_BROWSER_HANDLER, DefaultBrowserHandler.class.getName()).getImplementation();
        }
        catch (TechnicalConnectorException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void signin(SsoProfile profile) throws TechnicalConnectorException {
        this.signin(profile, null);
    }

    @Override
    public void setHandler(BrowserHandler handler) {
        this.browserHandler = handler;
    }

    @Override
    public void signin(SsoProfile profile, String relayState) throws TechnicalConnectorException {
        switch (profile) {
            case SAML2_ARTIFACT: {
                this.signinWithSAML2Artifact(relayState);
                break;
            }
            case SAML2_POST: {
                this.signinWithSAML2POST(relayState);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SSO profile [" + (Object)((Object)profile) + "]");
            }
        }
    }

    private void signinWithSAML2Artifact(String targetLocation) throws TechnicalConnectorException {
        try {
            String template = ConnectorIOUtils.getResourceAsString("/sso/SSORequestSTSSAML2Artifact.xml");
            template = StringUtils.replaceEach((String)template, (String[])new String[]{"${reqId}", "${endpoint.idp.saml2.artifact}"}, (String[])new String[]{this.idGenerator.generateId(), this.getSAML2Artifact()});
            NodeList references = this.invokeSecureTokenService(ConnectorXmlUtils.flatten(template)).getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
            Validate.notNull((Object)references);
            Validate.isTrue((references.getLength() == 1 ? 1 : 0) != 0);
            Element reference = (Element)references.item(0);
            String uri = reference.getAttribute("URI");
            if (StringUtils.isNotBlank((String)targetLocation)) {
                uri = uri + "&RelayState=" + targetLocation;
            }
            LOG.debug("Launching browser with url [" + uri + "]");
            this.browserHandler.browse(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, (Throwable)e, e.getMessage());
        }
    }

    private String getSAML2Post() {
        String hostname = this.config.getURLProperty(PROP_ENDPOINT_STS_SSO).getHost();
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.config.getProperty(PROP_SSO_AUTODISCOVERY_ENABLED, Boolean.TRUE.toString()))) {
            if ("services-acpt.ehealth.fgov.be".equals(hostname)) {
                return "https://wwwacc.ehealth.fgov.be/idp/profile/SAML2/Bearer/POST";
            }
            if ("services.ehealth.fgov.be".equals(hostname)) {
                return "https://www.ehealth.fgov.be/idp/profile/SAML2/Bearer/POST";
            }
        }
        return this.config.getProperty(PROP_ENDPOINT_IDP_SAML2_POST);
    }

    private String getSAML2Artifact() {
        String hostname = this.config.getURLProperty(PROP_ENDPOINT_STS_SSO).getHost();
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.config.getProperty(PROP_SSO_AUTODISCOVERY_ENABLED, Boolean.TRUE.toString()))) {
            if ("services-acpt.ehealth.fgov.be".equals(hostname)) {
                return "https://wwwacc.ehealth.fgov.be/idp/profile/SAML2/Bearer/Artifact";
            }
            if ("services.ehealth.fgov.be".equals(hostname)) {
                return "https://www.ehealth.fgov.be/idp/profile/SAML2/Bearer/Artifact";
            }
        }
        return this.config.getProperty(PROP_ENDPOINT_IDP_SAML2_ARTIFACT);
    }

    private void signinWithSAML2POST(String targetLocation) throws TechnicalConnectorException {
        FileWriter fw = null;
        try {
            String template = ConnectorIOUtils.getResourceAsString("/sso/SSORequestSTSSAML2POST.xml");
            template = StringUtils.replaceEach((String)template, (String[])new String[]{"${reqId}", "${endpoint.idp.saml2.post}"}, (String[])new String[]{this.idGenerator.generateId(), this.getSAML2Post()});
            NodeList assertions = this.invokeSecureTokenService(ConnectorXmlUtils.flatten(template)).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
            Validate.notNull((Object)assertions);
            Validate.isTrue((assertions.getLength() == 1 ? 1 : 0) != 0);
            Element assertion = (Element)assertions.item(0);
            String samlResponse = ConnectorIOUtils.getResourceAsString("/sso/bindingTemplate-SAMLResponse.xml");
            samlResponse = StringUtils.replaceEachRepeatedly((String)samlResponse, (String[])new String[]{"${SAMLResponseID}", "${SAMLResponseIssueInstant}", "${SAMLAssertion}"}, (String[])new String[]{IdGeneratorFactory.getIdGenerator("xsid").generateId(), new DateTime().toString(), this.toXMLString(assertion)});
            String templateForm = "";
            templateForm = StringUtils.isNotBlank((String)targetLocation) ? ConnectorIOUtils.getResourceAsString("/sso/bindingTemplate-Form.html") : ConnectorIOUtils.getResourceAsString("/sso/bindingTemplate-FormNoRelayState.html");
            templateForm = StringUtils.replaceEachRepeatedly((String)templateForm, (String[])new String[]{"${endpoint.idp.saml2.post}", "${relayState}", "${SAMLResponse}"}, (String[])new String[]{this.getSAML2Post(), targetLocation, new String(Base64.encode((byte[])ConnectorIOUtils.toBytes(ConnectorXmlUtils.flatten(samlResponse), Charset.UTF_8)))});
            File result = File.createTempFile("sso-", "post.html");
            result.deleteOnExit();
            URI uri = result.toURI();
            fw = new FileWriter(result);
            IOUtils.write((String)templateForm, (Writer)fw);
            fw.flush();
            this.browserHandler.browse(uri);
        }
        catch (IOException e) {
            try {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, (Throwable)e, e.getMessage());
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(fw);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)fw);
    }

    private String toXMLString(Element assertion) throws TechnicalConnectorException {
        try {
            StreamResult sr = new StreamResult(new StringWriter());
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "utf8");
            tf.setOutputProperty("indent", "no");
            tf.setOutputProperty("media-type", "text/xml");
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.transform(new DOMSource(assertion), sr);
            return sr.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, (Throwable)e, e.getMessage());
        }
    }

    private Element invokeSecureTokenService(String template) throws TechnicalConnectorException {
        try {
            GenericRequest request = new GenericRequest();
            request.setEndpoint(this.config.getProperty(PROP_ENDPOINT_STS_SSO));
            request.setCredential(this.getSamlToken(), TokenType.SAML);
            request.setSoapAction("urn:be:fgov:ehealth:sts:protocol:v1:RequestSecurityToken");
            request.setPayload(template);
            return (Element)ServiceFactory.getGenericWsSender().send(request).asNode();
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, e.getMessage());
        }
    }
}

