/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public abstract class AbstractSOAPHandler
implements SOAPHandler<SOAPMessageContext> {
    protected static final String IN = "IN";
    protected static final String OUT = "OUT";
    private static final int BLOCK = 1024;

    public boolean handleMessage(SOAPMessageContext context) {
        if (((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            return this.handleOutbound(context);
        }
        return this.handleInbound(context);
    }

    public boolean handleOutbound(SOAPMessageContext context) {
        return true;
    }

    public boolean handleInbound(SOAPMessageContext context) {
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public static void dumpMessage(SOAPMessage msg, String mode, Logger log) {
        if (msg == null) {
            return;
        }
        try {
            String content = ConnectorXmlUtils.toString((Node)msg.getSOAPPart().getEnvelope());
            int size = content.getBytes(Charset.UTF_8.getName()).length;
            if (content.getBytes().length < 0x100000) {
                log.debug("[" + mode + "] - " + size + " bytes - " + content);
            } else {
                log.warn("[" + mode + "] - " + size + " bytes - " + "message to large to log");
            }
        }
        catch (Exception e) {
            log.debug("Unable to dump message", (Throwable)e);
        }
    }
}

