/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.service.sts.STSService;
import be.ehealth.technicalconnector.service.sts.domain.SAMLAttribute;
import be.ehealth.technicalconnector.service.sts.domain.SAMLAttributeDesignator;
import be.ehealth.technicalconnector.service.sts.domain.SAMLNameIdentifier;
import be.ehealth.technicalconnector.service.sts.impl.AbstractSTSService;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.ws.ServiceFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import java.security.cert.CertificateEncodingException;
import java.util.HashSet;
import java.util.List;
import javax.xml.soap.SOAPException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.joda.time.DateTime;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STSServiceWsTrustImpl
extends AbstractSTSService
implements STSService {
    @Override
    public Element getToken(Credential headerCredentials, Credential bodyCredentials, List<SAMLAttribute> attributes, List<SAMLAttributeDesignator> designators, String authenticationMethod, String nameQualifier, String value, String subjectConfirmationMethod, int validity) throws TechnicalConnectorException {
        try {
            Element issuePayload = null;
            if ("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(subjectConfirmationMethod)) {
                issuePayload = this.issueHokToken(bodyCredentials, attributes, designators, validity);
            } else if ("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(subjectConfirmationMethod)) {
                SAMLNameIdentifier nameId = this.generateNameIdentifier(bodyCredentials, nameQualifier, value);
                issuePayload = this.issueSVToken(nameId, authenticationMethod, attributes, designators, validity);
            } else {
                throw new UnsupportedOperationException("SubjectConfirmationMethod [" + subjectConfirmationMethod + "] not supported.");
            }
            return this.processRequest(headerCredentials, bodyCredentials, issuePayload);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, e.getMessage());
        }
        catch (DOMException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, e.getMessage());
        }
    }

    @Override
    public Element getToken(Credential headerCredentials, Credential bodyCredentials, List<SAMLAttribute> attributes, List<SAMLAttributeDesignator> designators, String subjectConfirmationMethod, int validity) throws TechnicalConnectorException {
        return this.getToken(headerCredentials, bodyCredentials, attributes, designators, null, null, null, subjectConfirmationMethod, validity);
    }

    private Element issueHokToken(Credential bodyCredentials, List<SAMLAttribute> attributes, List<SAMLAttributeDesignator> designators, int validity) throws TechnicalConnectorException {
        try {
            Element claim;
            Element issuePayload = ConnectorXmlUtils.toElement(ConnectorXmlUtils.flatten(ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/wstrust/issue.samlv11.hok.template.xml"))).getBytes());
            issuePayload.setAttributeNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "Context", IdGeneratorFactory.getIdGenerator("uuid").generateId());
            Document doc = issuePayload.getOwnerDocument();
            Element claims = (Element)issuePayload.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "Claims").item(0);
            HashSet<String> claimsURI = new HashSet<String>();
            for (SAMLAttribute sAMLAttribute : attributes) {
                claim = doc.createElementNS("http://docs.oasis-open.org/wsfed/authorization/200706", "auth:ClaimType");
                claim.setAttribute("Uri", sAMLAttribute.getName());
                Element claimValue = doc.createElementNS("http://docs.oasis-open.org/wsfed/authorization/200706", "auth:Value");
                claimValue.setTextContent(StringUtils.join((Object[])sAMLAttribute.getValues(), (String)";"));
                claim.appendChild(claimValue);
                claims.appendChild(claim);
                claimsURI.add(sAMLAttribute.getName());
            }
            for (SAMLAttributeDesignator sAMLAttributeDesignator : designators) {
                if (claimsURI.contains(sAMLAttributeDesignator.getName())) continue;
                claim = doc.createElementNS("http://docs.oasis-open.org/wsfed/authorization/200706", "auth:ClaimType");
                claim.setAttribute("Uri", sAMLAttributeDesignator.getName());
                claims.appendChild(claim);
            }
            DateTime now = new DateTime();
            Element element = (Element)issuePayload.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created").item(0);
            element.setTextContent(DateUtils.printDateTime((DateTime)now));
            Element lifetimeExpires = (Element)issuePayload.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires").item(0);
            lifetimeExpires.setTextContent(DateUtils.printDateTime((DateTime)now.plusHours(validity)));
            Element x509Cert = (Element)issuePayload.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0);
            x509Cert.setTextContent(new String(Base64.encode((byte[])bodyCredentials.getCertificate().getEncoded())));
            return issuePayload;
        }
        catch (CertificateEncodingException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, e.getMessage());
        }
    }

    private Element issueSVToken(SAMLNameIdentifier nameIdentifier, String authmethod, List<SAMLAttribute> attributes, List<SAMLAttributeDesignator> designators, int validity) throws TechnicalConnectorException {
        String requestTemplate = "";
        requestTemplate = StringUtils.isEmpty((String)authmethod) ? ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/wstrust/issue.samlv11.sv.template.xml")) : ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/wstrust/issue.samlv11.sv.authmethod.template.xml"));
        String flattenRequest = ConnectorXmlUtils.flatten(requestTemplate);
        flattenRequest = this.processDefaultFields(flattenRequest, validity, nameIdentifier);
        flattenRequest = StringUtils.replace((String)flattenRequest, (String)"${authenticationMethod}", (String)authmethod);
        Element issuePayload = ConnectorXmlUtils.toElement(flattenRequest.getBytes());
        Document doc = issuePayload.getOwnerDocument();
        Element claims = (Element)issuePayload.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "Claims").item(0);
        for (SAMLAttributeDesignator attr : designators) {
            Element claim = doc.createElementNS("http://docs.oasis-open.org/wsfed/authorization/200706", "auth:ClaimType");
            claim.setAttribute("Uri", attr.getName());
            claims.appendChild(claim);
        }
        Element attributesStatement = (Element)issuePayload.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement").item(0);
        for (SAMLAttribute attr : attributes) {
            Element attrEl = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:Attribute");
            attrEl.setAttribute("AttributeName", attr.getName());
            attrEl.setAttribute("AttributeNamespace", attr.getNamespace());
            Element attrVal = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:AttributeValue");
            if (!ArrayUtils.isEmpty((Object[])attr.getValues())) {
                attrVal.setTextContent(attr.getValues()[0]);
            }
            attrEl.appendChild(attrVal);
            attributesStatement.appendChild(attrEl);
        }
        return issuePayload;
    }

    @Override
    public Element renewToken(Credential headerCredentials, Credential bodyCredentials, Element samlToken, int validity) throws TechnicalConnectorException {
        try {
            Element renewPayload = ConnectorXmlUtils.toElement(ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/wstrust/renew.samlv11.template.xml")).getBytes());
            renewPayload.setAttributeNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "Context", IdGeneratorFactory.getIdGenerator("uuid").generateId());
            NodeList embeddedList = renewPayload.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Embedded");
            Element embedded = (Element)embeddedList.item(0);
            embedded.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", "token-" + IdGeneratorFactory.getIdGenerator("uuid").generateId());
            Node samlTokenNode = renewPayload.getOwnerDocument().importNode(samlToken, true);
            embedded.appendChild(samlTokenNode);
            return this.processRequest(headerCredentials, bodyCredentials, renewPayload);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, e.getMessage());
        }
    }

    private Element processRequest(Credential headerCredentials, Credential bodyCredentials, Element payload) throws TechnicalConnectorException, SOAPException {
        NodeList nodeRequestedSecurityToken;
        GenericRequest request = ServiceFactory.getSTSService(headerCredentials.getCertificate(), headerCredentials.getPrivateKey());
        request.setSoapAction("urn:be:fgov:ehealth:sts:protocol:v1:RequestSecurityToken");
        request.setPayload(payload.getOwnerDocument());
        GenericResponse response = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(request);
        Element wsTrustElement = (Element)response.asNode();
        NodeList nodeChallenge = wsTrustElement.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "Challenge");
        if (nodeChallenge != null && nodeChallenge.getLength() >= 1) {
            GenericRequest requestChallenge = ServiceFactory.getSTSService(bodyCredentials.getCertificate(), bodyCredentials.getPrivateKey());
            requestChallenge.setSoapAction("urn:be:fgov:ehealth:sts:protocol:v1:Challenge");
            String requestTemplate = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/wstrust/signchallenge.template.xml"));
            String flattenRequest = ConnectorXmlUtils.flatten(requestTemplate);
            flattenRequest = StringUtils.replaceEach((String)flattenRequest, (String[])new String[]{"${context}", "${challenge}"}, (String[])new String[]{wsTrustElement.getAttribute("Context"), nodeChallenge.item(0).getTextContent()});
            Element issuePayload = ConnectorXmlUtils.toElement(flattenRequest.getBytes());
            Document doc = issuePayload.getOwnerDocument();
            requestChallenge.setPayload(doc);
            response = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(requestChallenge);
            wsTrustElement = (Element)response.asNode();
        }
        if ((nodeRequestedSecurityToken = wsTrustElement.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken")) != null && nodeRequestedSecurityToken.getLength() >= 1) {
            return ConnectorXmlUtils.getFirstChildElement(nodeRequestedSecurityToken.item(0));
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, "Unable to obtain token: reason unkown.");
    }
}

