/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.ra.utils;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.etkra.protocol.v2.StartETKRegistrationResponse;
import org.junit.Assert;
import org.junit.Test;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;


/**
 * @author EHP
 */
public class CertificateUtilsTest {

    @Test
    public void obtainSerialNumber() throws Exception {
        byte[] challenge = new MarshallerHelper<StartETKRegistrationResponse, StartETKRegistrationResponse>(StartETKRegistrationResponse.class, StartETKRegistrationResponse.class).toObject(ConnectorIOUtils.getResourceAsStream("/ra-samples/response/StartEtkRegistrationResponse.xml")).getChallenge();
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(ConnectorIOUtils.getResourceAsStream("/ra-samples/challenge.p12"), "15".toCharArray());
        Key key = store.getKey("0", "15".toCharArray());
        BigInteger serial = CertificateUtils.obtainSerialNumber((PrivateKey) key, challenge);
        Assert.assertEquals("248230155799496931490669725651394854648", serial.toString(10));
    }

}
