/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.impl.AbstractConfigurationImpl;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleLoader;
import be.ehealth.technicalconnector.config.impl.RecursiveProperties;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationImpl
extends AbstractConfigurationImpl {
    public static final String SYSPROP_MODULE_LOADING = "be.ehealth.technicalconnector.config.modules.load";
    private static volatile ConfigurationImpl instance;
    private static final Logger LOG;
    private boolean reloadAction;
    private Properties properties;

    private ConfigurationImpl() {
    }

    public static synchronized void reset() {
        instance = null;
    }

    @Override
    public void reload() throws TechnicalConnectorException {
        if (instance == null) {
            throw new IllegalStateException("reload called while instance is not initialized");
        }
        this.reloadAction = true;
        ConfigurationModuleLoader.load(instance);
        this.reloadAction = false;
    }

    @Override
    public boolean isReloading() {
        return this.reloadAction;
    }

    private void init() {
        if (this.properties == null) {
            try {
                this.properties = new RecursiveProperties();
                this.load(ConfigFactory.getConfigLocation(), this.properties);
            }
            catch (TechnicalConnectorException e) {
                LOG.error("Loading properties failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void load(String file, Properties props) {
        InputStream is;
        block10: {
            is = null;
            try {
                block9: {
                    LOG.info("Trying to load properties: " + file);
                    try {
                        is = ConnectorIOUtils.getResourceAsStream(file);
                    }
                    catch (TechnicalConnectorException e) {
                        if (!"/be.ehealth.technicalconnector.properties".equals(file)) break block9;
                        String moddedFile = "./" + file;
                        LOG.info("Trying to load properties: " + file);
                        is = ConnectorIOUtils.getResourceAsStream(moddedFile);
                    }
                }
                if (is != null) {
                    props.load(is);
                    break block10;
                }
                LOG.error("Loading properties failed: " + file);
            }
            catch (TechnicalConnectorException e) {
                LOG.error("Loading properties failed: " + file, (Throwable)e);
                ConnectorIOUtils.closeQuietly((Object)is);
            }
            catch (IOException e2) {
                LOG.error("Loading properties failed: " + file, (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        ConnectorIOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                ConnectorIOUtils.closeQuietly((Object)is);
            }
        }
        ConnectorIOUtils.closeQuietly((Object)is);
    }

    @Override
    @Deprecated
    public void setConfigLocation(String location) throws TechnicalConnectorException {
        ConfigFactory.setConfigLocation(location);
    }

    @Override
    public Configuration getCurrentConfig() throws TechnicalConnectorException {
        return ConfigurationImpl.getInstance();
    }

    public static synchronized Configuration getInstance() throws TechnicalConnectorException {
        if (instance == null) {
            instance = new ConfigurationImpl();
            if ("true".equals(System.getProperty(SYSPROP_MODULE_LOADING, "true"))) {
                instance.reload();
            }
        }
        return instance;
    }

    @Override
    public void setProperty(String key, String value) {
        if (!StringUtils.isEmpty((String)key)) {
            this.getProperties().remove(key);
            if (value != null) {
                this.getProperties().put(key, value);
            }
        }
    }

    @Override
    public boolean hasProperty(String key) {
        return this.getProperties().containsKey(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperties().getProperty(key, defaultValue);
        if (key != null && (this.endpointToTrim(key) || this.elseToTrim(key))) {
            return StringUtils.trim((String)value);
        }
        return value;
    }

    public boolean endpointToTrim(String key) {
        return !key.toLowerCase().contains("password") && "true".equals(this.getProperties().getProperty("configuration.properties.trim", "false").trim());
    }

    public boolean elseToTrim(String key) {
        return key.toLowerCase().startsWith("endpoint") && "true".equals(this.getProperties().getProperty("remove.trail.withspaces", "true").trim());
    }

    @Deprecated
    public Properties getProperties() {
        this.init();
        return this.properties;
    }

    @Override
    public void invalidate() {
        ConfigurationModuleLoader.unload();
    }

    static {
        LOG = LoggerFactory.getLogger(ConfigurationImpl.class);
    }
}

