﻿/*
 * Copyright (c) eHealth
 */

using System;
using be.ehealth.technicalconnector.idgenerator;
using be.fgov.ehealth.commons.core.v2;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using java.lang;
using org.joda.time;
using org.slf4j;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.dics.protocol.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

/**
 * Integration tests for tarification.
 * 
 * @author eHealth Platform
 * 
 */
namespace be.ehealth.businessconnector.dics.session
{
public class DicsIntegrationTest {

    /**
     * @param oa
     */
    public DicsIntegrationTest() {
        //super();
    }



    [SetUp]
    public static void setupsession()  {
        SessionInitializer.init(".\\be.ehealth.businessconnector.dics.test.properties", SupportedLanguages.NET.getAbbreviation());
    }

    [TearDown]
    public static void teardownSession()  {
        Session.getInstance().unloadSession();
    }

    [Test]
    public void findCNKRequestTest()  {
        FindCNKRequest request = new FindCNKRequest();
        request.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setLang("FR");
        request.setProductName("PERD");
        request.setStartDate(new org.joda.time.DateTime(2012, 10, 1, 0, 0, 0, 0));

        FindCNKResponse response = getSession().findCNK(request);

        getStringResult(response, response.getClass());
        Assert.IsNotNull(response.getProducts());
        Assert.AreNotEqual(0, response.getProducts().size());
    }

    [Test]
    public void findParagraphRequestTest()  {
        FindParagraphRequest request = new FindParagraphRequest();
        request.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setAmppId(2447803L);

        FindParagraphResponse response = getSession().findParagraph(request);

        getStringResult(response, response.getClass());
        Assert.IsNotNull(response.getFindParagraphs());
        Assert.AreNotEqual(0, response.getFindParagraphs().size());
    }

    [Test]
    public void findParagraphTextRequestTest()  {
        FindParagraphTextRequest request = new FindParagraphTextRequest();
        request.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setLang("FR");
        request.setChapterName("IV");
        request.setParagraphName("30200");
        request.setStartDate(new org.joda.time.DateTime(2012, 9, 1, 0, 0, 0, 0));

        FindParagraphTextResponse response = getSession().findParagraphText(request);

        getStringResult(response, response.getClass());
        Assert.IsNotNull(response.getParagraph());
    }

    [Test]
    public void findReimbursementConditionsRequestTest()  {
        FindReimbursementConditionsRequest request = new FindReimbursementConditionsRequest();
        request.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setLang("FR");
        request.setChapterName("IV");
        request.setParagraphName("170000");
        request.setStartDate(new org.joda.time.DateTime(2012, 9, 1, 0, 0, 0, 0));

        FindReimbursementConditionsResponse response = getSession().findReimbursementConditions(request);

        getStringResult(response, response.getClass());
        Assert.IsNotNull(response.getParagraphAndTherapies());
        Assert.AreNotEqual(0, response.getParagraphAndTherapies().size());
    }

    [Test]
    public void getAddedDocumentsRequestTest()  {
        GetAddedDocumentsRequest request = new GetAddedDocumentsRequest();
        request.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setLang("FR");
        request.setChapterName("IV");
        request.setParagraphName("1750000");

        GetAddedDocumentsResponse response = getSession().getAddedDocuments(request);

        getStringResult(response, response.getClass());
        Assert.IsNotNull(response.getAddedDocuments());
        Assert.AreNotEqual(0, response.getAddedDocuments().size());
    }

    [Test]
    public void getParagraphExclusionsRequestTest()  {
        GetParagraphExclusionsRequest request = new GetParagraphExclusionsRequest();
        request.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setLang("FR");
        request.setChapterName("IV");
        request.setParagraphName("1570000");
        request.setStartDate(new org.joda.time.DateTime(2012, 10, 1, 0, 0, 0, 0));

        GetParagraphExclusionsResponse response = getSession().getParagraphExclusions(request);

        getStringResult(response, response.getClass());
        Assert.IsNotNull(response.getExcludedParagraphs());
        Assert.AreNotEqual(0, response.getExcludedParagraphs().size());
    }

    [Test]
    public void getParagraphIncludedSpecialtiesRequestTest()  {
        GetParagraphIncludedSpecialtiesRequest request = new GetParagraphIncludedSpecialtiesRequest();
        request.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setLang("FR");
        request.setChapterName("IV");
        request.setParagraphName("40100");
        request.setStartDate(new org.joda.time.DateTime(2012, 10, 1, 0, 0, 0, 0));

        GetParagraphIncludedSpecialtiesResponse response = getSession().getParagraphIncludedSpecialities(request);

        getStringResult(response, response.getClass());
        Assert.IsNotNull(response.getAtmAndChildrens());
        Assert.AreNotEqual(0, response.getAtmAndChildrens().size());
    }

    [Test]
    public void getProfessionalAuthorizationsRequestTest()  {
        GetProfessionalAuthorizationsRequest request = new GetProfessionalAuthorizationsRequest();
        request.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setLang("FR");
        request.setQualificationListId("121");

        GetProfessionalAuthorizationsResponse response = getSession().getProfessionalAuthorizations(request);

        getStringResult(response, response.getClass());
        Assert.IsNotNull(response.getProfessionalAuthorizations());
        Assert.AreNotEqual(0, response.getProfessionalAuthorizations().size());
    }


    /**
     * @return
     * @throws ConnectorException
     */
    private DicsSessionService getSession()  {
        DicsSessionService session = DicsSessionServiceFactory.getTarificationSession();
        return session;
    }

    /**
     * @param response
     * @throws Exception
     */
    private void getStringResult(java.lang.Object response, Class classToUnmarshall)  {
        MarshallerHelper responseMarshaller;
        responseMarshaller = new MarshallerHelper(classToUnmarshall, classToUnmarshall);
        responseMarshaller.toString(response);
    }


    /**
     * @param result
     * @param fileName
     * @throws FileNotFoundException
     * @throws IOException
     */
    private void saveFileValue(byte[] fileValue, string fileName)  {
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(fileValue);
        fos.close();
    }

}
}