/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.services.daas;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.daas.complextype.v1.Actor;
import be.fgov.ehealth.daas.complextype.v1.RoutingInformation;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.w3c.dom.Node;

public class AttributeValue {
    private Object value;

    public AttributeValue(Object value) {
        this.value = value;
    }

    public ValueType getValueType() {
        if (this.value instanceof String) {
            return ValueType.STRING;
        }
        if (this.value instanceof Node) {
            return ValueType.NODE;
        }
        if (this.value instanceof Actor) {
            return ValueType.ACTOR;
        }
        if (this.value instanceof RoutingInformation) {
            return ValueType.ROUTING_INFORMATION;
        }
        return ValueType.UNKNOWN_OBJECT;
    }

    public String asString() throws TechnicalConnectorException {
        if (this.value instanceof String) {
            return this.asObject(String.class);
        }
        if (this.value instanceof Node) {
            return ConnectorXmlUtils.toString((Node)((Node)this.value));
        }
        return ConnectorXmlUtils.toString((Object)this.value);
    }

    public Node asNode() throws TechnicalConnectorException {
        if (this.value instanceof String) {
            return ConnectorXmlUtils.getDocumentBuilder().newDocument().createTextNode((String)this.value);
        }
        if (this.value instanceof Node) {
            return (Node)this.value;
        }
        return ConnectorXmlUtils.toDocument((Object)this.value);
    }

    public Actor asActor() throws TechnicalConnectorException {
        return this.asObject(Actor.class);
    }

    public RoutingInformation asRoutingInformation() throws TechnicalConnectorException {
        return this.asObject(RoutingInformation.class);
    }

    public <T> T asObject(Class<T> clazz) throws TechnicalConnectorException {
        Validate.notNull(clazz);
        if (this.value.getClass().isAssignableFrom(clazz)) {
            return (T)this.value;
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, new Object[]{"Unable to cast object to disered type [" + clazz.getName() + "]"});
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static enum ValueType {
        STRING,
        NODE,
        ACTOR,
        ROUTING_INFORMATION,
        UNKNOWN_OBJECT;

    }
}

