/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.util.encoders.Base64;

public class EncryptionToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final X509Certificate encrCert;
    private final byte[] encoded;
    private final X509Certificate authCert;
    private final X509Certificate etkRaCert;
    private final List<X509Certificate> caCertChain;

    EncryptionToken(byte[] encoded, X509Certificate encrCert, X509Certificate authCert, List<X509Certificate> caCertChain, X509Certificate etkRaCert) {
        Preconditions.checkNotNull(encoded, "ETK encoded bytes cannot be null.");
        Preconditions.checkNotNull(encrCert, "ETK Encryption Certification cannot be null.");
        Preconditions.checkNotNull(authCert, "ETK Authentication Certification cannot be null.");
        Preconditions.checkNotNull(caCertChain, "ETK CA Chain cannot be null.");
        Preconditions.checkNotNull(etkRaCert, "ETK RA Certification cannot be null.");
        this.encoded = (byte[])encoded.clone();
        this.encrCert = encrCert;
        this.authCert = authCert;
        this.caCertChain = caCertChain;
        this.etkRaCert = etkRaCert;
    }

    public final byte[] getEncoded() {
        return this.encoded != null ? (byte[])this.encoded.clone() : null;
    }

    public final byte[] getBase64Encoded() {
        return Base64.encode((byte[])this.encoded);
    }

    public final X509Certificate getCertificate() {
        return this.encrCert;
    }

    public final X509Certificate getAuthenticationCertificate() {
        return this.authCert;
    }

    List<X509Certificate> getCaCertChain() {
        return this.caCertChain;
    }

    X509Certificate getEtkRaCert() {
        return this.etkRaCert;
    }
}

