package be.ehealth.businessconnector.test.dicsv5.session;

import be.ehealth.businessconnector.dicsv5.exception.DicsException;
import be.ehealth.businessconnector.dicsv5.session.DicsSessionServiceFactory;
import be.ehealth.businessconnector.test.testcommons.utils.FileTestUtils;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.dics.protocol.v5.FindAmpRequest;
import be.fgov.ehealth.dics.protocol.v5.FindAmpResponse;
import be.fgov.ehealth.dics.protocol.v5.FindAmppRequest;
import be.fgov.ehealth.dics.protocol.v5.FindAmppResponse;
import be.fgov.ehealth.dics.protocol.v5.FindCommentedClassificationRequest;
import be.fgov.ehealth.dics.protocol.v5.FindCommentedClassificationResponse;
import be.fgov.ehealth.dics.protocol.v5.FindCompanyRequest;
import be.fgov.ehealth.dics.protocol.v5.FindCompanyResponse;
import be.fgov.ehealth.dics.protocol.v5.FindCompoundingFormulaRequest;
import be.fgov.ehealth.dics.protocol.v5.FindCompoundingFormulaResponse;
import be.fgov.ehealth.dics.protocol.v5.FindCompoundingIngredientRequest;
import be.fgov.ehealth.dics.protocol.v5.FindCompoundingIngredientResponse;
import be.fgov.ehealth.dics.protocol.v5.FindLegislationTextRequest;
import be.fgov.ehealth.dics.protocol.v5.FindLegislationTextResponse;
import be.fgov.ehealth.dics.protocol.v5.FindListOfAmpRequest;
import be.fgov.ehealth.dics.protocol.v5.FindListOfAmpResponse;
import be.fgov.ehealth.dics.protocol.v5.FindNonMedicinalProductRequest;
import be.fgov.ehealth.dics.protocol.v5.FindNonMedicinalProductResponse;
import be.fgov.ehealth.dics.protocol.v5.FindReferencesRequest;
import be.fgov.ehealth.dics.protocol.v5.FindReferencesResponse;
import be.fgov.ehealth.dics.protocol.v5.FindReimbursementRequest;
import be.fgov.ehealth.dics.protocol.v5.FindReimbursementResponse;
import be.fgov.ehealth.dics.protocol.v5.FindVmpGroupRequest;
import be.fgov.ehealth.dics.protocol.v5.FindVmpGroupResponse;
import be.fgov.ehealth.dics.protocol.v5.FindVmpRequest;
import be.fgov.ehealth.dics.protocol.v5.FindVmpResponse;
import be.fgov.ehealth.dics.protocol.v5.FindVtmRequest;
import be.fgov.ehealth.dics.protocol.v5.FindVtmResponse;
import be.fgov.ehealth.dics.protocol.v5.ValidateProductIdRequest;
import be.fgov.ehealth.dics.protocol.v5.ValidateProductIdResponse;
import be.fgov.ehealth.dics.protocol.v5.ValidateSamIdRequest;
import be.fgov.ehealth.dics.protocol.v5.ValidateSamIdResponse;
import be.fgov.ehealth.errors.core.v1.LocalisedStringType;
import be.fgov.ehealth.errors.soa.v1.BusinessError;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import org.apache.commons.lang.RandomStringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

import javax.xml.soap.DetailEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DicsSessionServiceIntegrationTest {

    @ClassRule
    public static SessionRule sessionRule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.dicsv5.test.properties").build();

    @Test
    public void findAmpTest() throws Exception {
        FindAmpRequest request = transformRequest("/examples/request/findAmpRequest.xml", FindAmpRequest.class);
        FindAmpResponse response = DicsSessionServiceFactory.getDicsSession().findAmp(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findAmpResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findAmpWithErrorTest() throws Exception {
        FindAmpRequest request = transformRequest("/examples/request/findAmpRequest-error.xml", FindAmpRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findAmp(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1003", "No AMP found for given criteria.");
        }
    }

    @Test
    public void findCompanyTest() throws Exception {
        FindCompanyRequest request = transformRequest("/examples/request/findCompanyRequest.xml", FindCompanyRequest.class);
        FindCompanyResponse response = DicsSessionServiceFactory.getDicsSession().findCompany(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findCompanyResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findCompanyErrorTest() throws Exception {
        FindCompanyRequest request = transformRequest("/examples/request/findCompanyRequest-error.xml", FindCompanyRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findCompany(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1004", "No company found for given criteria.");
        }
    }

    @Test
    public void findVmpTest() throws Exception {
        FindVmpRequest request = transformRequest("/examples/request/findVmpRequest.xml", FindVmpRequest.class);
        FindVmpResponse response = DicsSessionServiceFactory.getDicsSession().findVmp(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVmpResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findVmpErrorTest() throws Exception {
        FindVmpRequest request = transformRequest("/examples/request/findVmpRequest-error.xml", FindVmpRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findVmp(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1005", "No VMP found for given criteria.");
        }
    }

    @Test
    public void findLegislationTextTest() throws Exception {
        FindLegislationTextRequest request = transformRequest("/examples/request/findLegislationTextRequest.xml", FindLegislationTextRequest.class);
        FindLegislationTextResponse response = DicsSessionServiceFactory.getDicsSession().findLegislationText(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findLegislationTextResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findLegislationTextErrorTest() throws Exception {
        FindLegislationTextRequest request = transformRequest("/examples/request/findLegislationTextRequest-error.xml", FindLegislationTextRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findLegislationText(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1007", "No legislation text found for given criteria");
        }
    }

    @Test
    public void findReimbursementTest() throws Exception {
        FindReimbursementRequest request = transformRequest("/examples/request/findReimbursementRequest.xml", FindReimbursementRequest.class);
        FindReimbursementResponse response = DicsSessionServiceFactory.getDicsSession().findReimbursement(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findReimbursementResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findReimbursementErrorTest() throws Exception {
        FindReimbursementRequest request = transformRequest("/examples/request/findReimbursementRequest-error.xml", FindReimbursementRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findReimbursement(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1008", "No reimbursements found for given criteria.");
        }
    }

    @Test
    public void findReferencesTest() throws Exception {
        FindReferencesRequest request = transformRequest("/examples/request/findReferencesRequest.xml", FindReferencesRequest.class);
        FindReferencesResponse response = DicsSessionServiceFactory.getDicsSession().findReferences(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findReferencesResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findReferencesErrorTest() throws Exception {
        FindReferencesRequest request = transformRequest("/examples/request/findReferencesRequest-error.xml", FindReferencesRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findReferences(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "0804", "Invalid reference entity 'INVALID_REFERENCE_ENTITY'");
        }
    }

    @Test
    public void findVmpGroupTest() throws Exception {
        FindVmpGroupRequest request = transformRequest("/examples/request/findVmpGroupRequest.xml", FindVmpGroupRequest.class);
        FindVmpGroupResponse response = DicsSessionServiceFactory.getDicsSession().findVmpGroup(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVmpGroupResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findVmpGroupErrorTest() throws Exception {
        FindVmpGroupRequest request = transformRequest("/examples/request/findVmpGroupRequest-error.xml", FindVmpGroupRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findVmpGroup(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1006", "No VMP group found for given criteria.");
        }
    }

    @Test
    public void findVtmTest() throws Exception {
        FindVtmRequest request = transformRequest("/examples/request/findVtmRequest.xml", FindVtmRequest.class);
        FindVtmResponse response = DicsSessionServiceFactory.getDicsSession().findVtm(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findVtmResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findVtmErrorTest() throws Exception {
        FindVtmRequest request = transformRequest("/examples/request/findVtmRequest-error.xml", FindVtmRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findVtm(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1011", "No VTM found for given criteria.");
        }
    }

    @Test
    public void findCommentedClassificationTest() throws Exception {
        FindCommentedClassificationRequest request = transformRequest("/examples/request/findCommentedClassificationRequest.xml", FindCommentedClassificationRequest.class);
        FindCommentedClassificationResponse response = DicsSessionServiceFactory.getDicsSession().findCommentedClassification(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findCommentedClassificationResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findCommentedClassificationErrorTest() throws Exception {
        FindCommentedClassificationRequest request = transformRequest("/examples/request/findCommentedClassificationRequest-error.xml", FindCommentedClassificationRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findCommentedClassification(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1012", "No Com Cls found for given criteria.");
        }
    }

    @Test
    public void findIngredientTest() throws Exception {
        FindCompoundingIngredientRequest request = transformRequest("/examples/request/findIngredientRequest.xml", FindCompoundingIngredientRequest.class);
        FindCompoundingIngredientResponse response = DicsSessionServiceFactory.getDicsSession().findIngredient(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findIngredientResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findIngredientErrorTest() throws Exception {
        FindCompoundingIngredientRequest request = transformRequest("/examples/request/findIngredientRequest-error.xml", FindCompoundingIngredientRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findIngredient(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1013", "No ingredient found for given criteria.");
        }
    }

    @Test
    public void findFormulaTest() throws Exception {
        FindCompoundingFormulaRequest request = transformRequest("/examples/request/findFormulaRequest.xml", FindCompoundingFormulaRequest.class);
        FindCompoundingFormulaResponse response = DicsSessionServiceFactory.getDicsSession().findFormula(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findFormulaResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findFormulaErrorTest() throws Exception {
        FindCompoundingFormulaRequest request = transformRequest("/examples/request/findFormulaRequest-error.xml", FindCompoundingFormulaRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findFormula(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1014", "No formula found for given criteria.");
        }
    }

    @Test
    @Ignore("This was never implemented and will probably never be")
    public void findAmppTest() throws Exception {
        FindAmppRequest request = transformRequest("/examples/request/findAmppRequest.xml", FindAmppRequest.class);
        FindAmppResponse response = DicsSessionServiceFactory.getDicsSession().findAmpp(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findAmppResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    @Ignore("This was never implemented and will probably never be")
    public void findAmppErrorTest() throws Exception {
        FindAmppRequest request = transformRequest("/examples/request/findAmppRequest-error.xml", FindAmppRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findAmpp(request);
        } catch (DicsException de) {
            assertDicsException(de, "", "", "");
        }
    }

    @Test
    public void findNonMedicinalProductTest() throws Exception {
        FindNonMedicinalProductRequest request = transformRequest("/examples/request/findNonMedicinalProductRequest.xml", FindNonMedicinalProductRequest.class);
        FindNonMedicinalProductResponse response = DicsSessionServiceFactory.getDicsSession().findNonMedicinalProduct(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findNonMedicinalProductResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findNonMedicinalProductErrorTest() throws Exception {
        FindNonMedicinalProductRequest request = transformRequest("/examples/request/findNonMedicinalProductRequest-error.xml", FindNonMedicinalProductRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findNonMedicinalProduct(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1015", "No non medicinal products found for given criteria.");
        }
    }

    @Test
    public void findListOfAmpTest() throws Exception {
        FindListOfAmpRequest request = transformRequest("/examples/request/findListOfAmpRequest.xml", FindListOfAmpRequest.class);
        FindListOfAmpResponse response = DicsSessionServiceFactory.getDicsSession().findListOfAmp(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findListOfAmpResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void findListOfAmpErrorTest() throws Exception {
        FindListOfAmpRequest request = transformRequest("/examples/request/findListOfAmpRequest-error.xml", FindListOfAmpRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().findListOfAmp(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1003", "No AMP found for given criteria.");
        }
    }

    @Test
    public void validateSamIdTest() throws Exception {
        FindAmpRequest findAmpRequest = transformRequest("/examples/request/findAmpRequest.xml", FindAmpRequest.class);
        FindAmpResponse findAmpResponse = DicsSessionServiceFactory.getDicsSession().findAmp(findAmpRequest);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/findAmpResponse.xml"), ConnectorXmlUtils.toString(findAmpResponse));

        Map<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("samId", findAmpResponse.getSamId());

        ValidateSamIdRequest request = transformRequest("/examples/request/validateSamIdRequest.xml", ValidateSamIdRequest.class, extraContext);
        ValidateSamIdResponse response = DicsSessionServiceFactory.getDicsSession().validateSamId(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/validateSamIdResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void validateSamIdErrorTest() throws Exception {
        ValidateSamIdRequest request = transformRequest("/examples/request/validateSamIdRequest-error.xml", ValidateSamIdRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().validateSamId(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1301", "Could not parse SamId because it is invalid.");
        }
    }

    @Test
    public void validateProductIdTest() throws Exception {
        ValidateProductIdRequest request = transformRequest("/examples/request/validateProductIdRequest.xml", ValidateProductIdRequest.class);
        ValidateProductIdResponse response = DicsSessionServiceFactory.getDicsSession().validateProductId(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/validateProductIdResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void validateProductIdErrorTest() throws Exception {
        ValidateProductIdRequest request = transformRequest("/examples/request/validateProductIdRequest-error.xml", ValidateProductIdRequest.class);
        try {
            DicsSessionServiceFactory.getDicsSession().validateProductId(request);
        } catch (DicsException de) {
            assertDicsException(de, "Consumer", "1301", "Could not parse SamId because it is invalid.");
        }
    }

    private void assertDicsException(DicsException dicsException, String origin, String code, String message) {
        List<DetailEntry> entries = new ArrayList<DetailEntry>();
        Iterator it = dicsException.getFault().getDetail().getDetailEntries();
        while (it.hasNext()) entries.add((DetailEntry) it.next());

        Assert.assertEquals(1, entries.size());

        MarshallerHelper<BusinessError, BusinessError> helper = new MarshallerHelper<BusinessError, BusinessError>(BusinessError.class, BusinessError.class);
        BusinessError error = helper.toObject(entries.get(0));

        Assert.assertEquals(code, error.getCode());
        Assert.assertEquals(origin, error.getOrigin());

        List<LocalisedStringType> messages = error.getMessages();
        Assert.assertEquals(1, messages.size());
        Assert.assertEquals(message, messages.get(0).getValue());
    }

    private <T> T transformRequest(String fileLocation, Class<T> clazz) throws Exception {
        return transformRequest(fileLocation, clazz, null);
    }

    private <T> T transformRequest(String fileLocation, Class<T> clazz, Map<String, Object> extraContext) throws Exception {
        Map<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("issueInstant", DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'+02:00'").print(new DateTime()));
        velocityContext.put("requestId", IdGeneratorFactory.getIdGenerator("uuid").generateId());
        velocityContext.put("currentDate", DateTimeFormat.forPattern("yyyy-MM-dd").print(new DateTime()));
        velocityContext.put("generatedChars1", RandomStringUtils.randomAlphabetic(10).toLowerCase());
        velocityContext.put("generatedChars2", RandomStringUtils.randomAlphabetic(10).toLowerCase());

        if (extraContext != null && !extraContext.isEmpty()) {
            for (String key : extraContext.keySet()) {
                velocityContext.put(key, extraContext.get(key));
            }
        }

        return FileTestUtils.toObject(velocityContext, fileLocation, clazz);
    }

}
