/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genericasync.domain;

import java.util.ArrayList;
import java.util.List;

public class GetRequest {
    private String reference;
    private Integer maxMessages;
    private Integer maxTAcks;
    private List<String> includeIOs;
    private List<String> excludeIOs;
    private List<String> tackMessageNames;

    private GetRequest(Builder.BasicSteps builder) {
        this.reference = builder.reference;
        this.maxMessages = builder.maxMessages;
        this.maxTAcks = builder.maxTAcks;
        this.includeIOs = builder.includeIOs;
        this.excludeIOs = builder.excludeIOs;
        this.tackMessageNames = builder.tackMessageNames;
    }

    public static Builder.GetRequestBuilderStep newBuilder() {
        return new Builder.GetRequestSteps();
    }

    public String getReference() {
        return this.reference;
    }

    public Integer getMaxMessages() {
        return this.maxMessages;
    }

    public Integer getMaxTAcks() {
        return this.maxTAcks;
    }

    public List<String> getIncludeIOs() {
        return this.includeIOs;
    }

    public List<String> getExcludeIOs() {
        return this.excludeIOs;
    }

    public List<String> getTackMessageNames() {
        return this.tackMessageNames;
    }

    public static final class Builder {
        private Builder() {
        }

        private static class BasicSteps
        implements DefaultsStep,
        ReferenceStep,
        MaxMessagesStep,
        MaxTAcksStep,
        IncludeIOsStep,
        ExcludeIOsStep,
        TackMessageNamesStep,
        BuildStep {
            private Integer maxMessages;
            private Integer maxTAcks;
            private String reference;
            private List<String> includeIOs = new ArrayList<String>();
            private List<String> excludeIOs = new ArrayList<String>();
            private List<String> tackMessageNames;

            private BasicSteps() {
            }

            @Override
            public BuildStep withDefaults() {
                return this;
            }

            @Override
            public BuildStep withReference(String reference) {
                this.reference = reference;
                return this;
            }

            @Override
            public MaxTAcksStep withMaxMessages(Integer maxMessages) {
                this.maxMessages = maxMessages;
                return this;
            }

            @Override
            public IncludeIOsStep withMaxTAcks(Integer maxTAcks) {
                this.maxTAcks = maxTAcks;
                return this;
            }

            @Override
            public ExcludeIOsStep withIncludeIOs(List<String> includeIOs) {
                this.includeIOs = includeIOs;
                return this;
            }

            @Override
            public TackMessageNamesStep withExcludeIOs(List<String> excludeIOs) {
                this.excludeIOs = excludeIOs;
                return this;
            }

            @Override
            public BuildStep withTackMessageNames(List<String> tackMessageNames) {
                this.tackMessageNames = tackMessageNames;
                return this;
            }

            @Override
            public GetRequest build() {
                return new GetRequest(this);
            }
        }

        public static interface BuildStep {
            public GetRequest build();
        }

        public static interface TackMessageNamesStep {
            public BuildStep withTackMessageNames(List<String> var1);

            public GetRequest build();
        }

        public static interface ExcludeIOsStep {
            public TackMessageNamesStep withExcludeIOs(List<String> var1);

            public GetRequest build();
        }

        public static interface IncludeIOsStep {
            public ExcludeIOsStep withIncludeIOs(List<String> var1);

            public GetRequest build();
        }

        public static interface MaxTAcksStep {
            public IncludeIOsStep withMaxTAcks(Integer var1);

            public GetRequest build();
        }

        public static interface MaxMessagesStep {
            public MaxTAcksStep withMaxMessages(Integer var1);
        }

        public static interface ReferenceStep {
            public BuildStep withReference(String var1);
        }

        public static interface DefaultsStep {
            public BuildStep withDefaults();
        }

        static class GetRequestSteps
        implements GetRequestBuilderStep {
            GetRequestSteps() {
            }

            @Override
            public BuildStep withReference(String reference) {
                return new BasicSteps().withReference(reference);
            }

            @Override
            public MaxTAcksStep withMaxMessages(Integer maxMessages) {
                return new BasicSteps().withMaxMessages(maxMessages);
            }

            @Override
            public BuildStep withDefaults() {
                return new BasicSteps().withDefaults();
            }
        }

        public static interface GetRequestBuilderStep {
            public BuildStep withReference(String var1);

            public MaxTAcksStep withMaxMessages(Integer var1);

            public BuildStep withDefaults();
        }
    }
}

