/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.exception.InstantiationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ConnectorXmlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorXmlUtils.class);
    private static TransformerFactory trfactory = TransformerFactory.newInstance();

    public static DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ConnectorXmlUtils() {
        throw new UnsupportedOperationException();
    }

    public static Element getFirstElementByTagNameNS(Element node, String namespaceURI, String localName) {
        NodeList nodeList = node.getElementsByTagNameNS(namespaceURI, localName);
        if (nodeList.getLength() == 0) {
            return null;
        }
        if (nodeList.getLength() > 1) {
            LOG.debug("{}:{} elements count: {} ,returning first one", new Object[]{namespaceURI, localName, nodeList.getLength()});
        }
        return (Element)nodeList.item(0);
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    public static void dump(Object obj) {
        if (LOG.isDebugEnabled()) {
            try {
                if (obj != null) {
                    String xmlString = ConnectorXmlUtils.toString(obj);
                    LOG.debug("Contents of " + obj.getClass().getCanonicalName() + "  : " + xmlString + "");
                }
            }
            catch (Exception e) {
                LOG.error("Error occured while logging contents of object " + obj.getClass().getCanonicalName() + ". Reason: " + e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(Node node) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(out);
            Transformer transformer = trfactory.newTransformer();
            transformer.transform(source, result);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOG.error(e.getClass().getSimpleName() + ":" + e.getMessage());
            return new byte[0];
        }
    }

    public static byte[] toByteArray(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toXMLByteArray(obj);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document toDocument(byte[] data) throws TechnicalConnectorException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            Document document = ConnectorXmlUtils.getDocumentBuilder().parse(in);
            return document;
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    public static Document toDocument(Source source) throws TechnicalConnectorException {
        try {
            DOMResult result = new DOMResult();
            trfactory.newTransformer().transform(source, result);
            return result.getNode().getOwnerDocument();
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    public static Document toDocument(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toDocument(obj);
    }

    public static Document toDocument(String xml) throws TechnicalConnectorException {
        try {
            return ConnectorXmlUtils.parseXmlFile(xml);
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    public static Element toElement(byte[] data) throws TechnicalConnectorException {
        return ConnectorXmlUtils.toDocument(data).getDocumentElement();
    }

    public static <T> T toObject(InputStream in, Class<T> clazz) {
        MarshallerHelper<T, T> helper = new MarshallerHelper<T, T>(clazz, clazz);
        return helper.toObject(in);
    }

    public static <T> T toObject(byte[] in, Class<T> clazz) {
        MarshallerHelper<T, T> helper = new MarshallerHelper<T, T>(clazz, clazz);
        return helper.toObject(in);
    }

    public static <T> T toObject(String xml, Class<T> clazz) {
        MarshallerHelper<T, T> helper = new MarshallerHelper<T, T>(clazz, clazz);
        return helper.toObject(xml);
    }

    public static String toString(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toString(obj);
    }

    public static String toString(Node node) throws TechnicalConnectorException {
        return ConnectorXmlUtils.toString(new DOMSource(node));
    }

    public static String toString(Source source) throws TechnicalConnectorException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Transformer tf = trfactory.newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(outputStream);
            tf.transform(source, result);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)outputStream);
        }
    }

    public static String flatten(String xml) {
        String result = RegExUtils.replaceAll((String)xml, (String)"[\t\n\r]", (String)"");
        while (result.contains(" <")) {
            result = RegExUtils.replaceAll((String)result, (String)" <", (String)"<");
        }
        return result;
    }

    public static String format(String unformattedXml) {
        return ConnectorXmlUtils.format(unformattedXml, null);
    }

    public static String format(String unformattedXml, Source xslt) {
        return ConnectorXmlUtils.xslt(new DOMSource(ConnectorXmlUtils.parseXmlFile(unformattedXml)), xslt);
    }

    public static String xslt(Source doc, Source xslt) {
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer transformer = xslt != null ? trfactory.newTransformer(xslt) : trfactory.newTransformer();
            LOG.debug("Transformer implementation {}", transformer.getClass());
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(1));
            transformer.transform(doc, result);
            return writer.toString();
        }
        catch (Exception e) {
            throw new InstantiationException(e);
        }
    }

    public static String sanitizePartId(String contentId) {
        try {
            String cid = URLDecoder.decode(contentId, StandardCharsets.UTF_8.name());
            if (StringUtils.startsWith((CharSequence)cid, (CharSequence)"<") && StringUtils.endsWith((CharSequence)cid, (CharSequence)">")) {
                cid = StringUtils.substringBetween((String)cid, (String)"<", (String)">");
            }
            return StringUtils.replace((String)cid, (String)"cid:", (String)"");
        }
        catch (UnsupportedEncodingException e) {
            throw new InstantiationException(e);
        }
    }

    private static Document parseXmlFile(String in) {
        try {
            InputSource is = new InputSource(new StringReader(in));
            return ConnectorXmlUtils.getDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw new InstantiationException(e);
        }
    }
}

