/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.util;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.Configurable;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class ConfigUtils {
    private static Log logger = LogFactory.getLog(ConfigUtils.class);

    public static <T extends Configurable> T getConfiguredInstanceOf(Class<? extends T> type, Properties configuration, String ... implementationDiscriminatorValues) {
        Configurable result = (Configurable)ConfigUtils.getInstanceOf(type, configuration, implementationDiscriminatorValues);
        result.init(configuration);
        return (T)result;
    }

    public static <T> T getInstanceOf(Class<? extends T> type, Properties configuration, String ... implementationDiscriminatorValues) {
        String implClassName = ConfigUtils.getConfiguredClassName(type, configuration, implementationDiscriminatorValues);
        logger.debug((Object)("Creating instance of " + type + ". Implementation class " + implClassName));
        return ReflectionUtils.createInstanceOfType(implClassName, false);
    }

    public static String getConfiguredClassName(Class<?> type, Properties configuration, String ... implementationDiscriminatorValues) {
        String propKey = type.getName() + ".implClassName";
        if (implementationDiscriminatorValues != null) {
            String implementationSpecificPropKey = propKey;
            for (String implementationDiscriminatorValue : implementationDiscriminatorValues) {
                implementationSpecificPropKey = implementationSpecificPropKey + '.' + implementationDiscriminatorValue;
            }
            if (configuration.containsKey(implementationSpecificPropKey)) {
                return PropertyUtils.getString(implementationSpecificPropKey, configuration);
            }
        }
        if (configuration.containsKey(propKey)) {
            return PropertyUtils.getString(propKey, configuration);
        }
        throw new UnitilsException("Missing configuration for " + propKey);
    }
}

