/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.ocsp;

import be.fgov.ehealth.etee.crypto.ocsp.OCSPClient;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPClientImpl;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPConnector;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPRequestBuilder;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPURLReader;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPOptions;

final class OCSPClientFactory {
    private static OCSPClientFactory instance;

    private OCSPClientFactory() {
    }

    public static OCSPClientFactory getInstance() {
        if (instance == null) {
            instance = new OCSPClientFactory();
        }
        return instance;
    }

    public OCSPClient createOCSPClient(OCSPOptions options) {
        int connectTimeout = options.getInteger(OCSPOption.CONNECTION_TIMEOUT);
        int readTimeout = options.getInteger(OCSPOption.READ_TIMEOUT);
        boolean isUserInteractionAllowed = options.getBoolean(OCSPOption.CONNECTION_USER_INTERACTION);
        String ocspUrl = options.getString(OCSPOption.OCSP_URI);
        long clockSkew = options.getLong(OCSPOption.CLOCK_SKEW);
        OCSPConnector ocspRequestor = new OCSPConnector(connectTimeout, readTimeout, isUserInteractionAllowed);
        OCSPRequestBuilder ocspRequestBuilder = new OCSPRequestBuilder();
        OCSPURLReader ocspURLReader = new OCSPURLReader(ocspUrl);
        return new OCSPClientImpl(ocspRequestor, ocspRequestBuilder, ocspURLReader, clockSkew);
    }
}

