/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.encrypt.CmsEncrypter;
import be.fgov.ehealth.etee.crypto.encrypt.CmsSigner;
import be.fgov.ehealth.etee.crypto.encrypt.CmsSignerFactory;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealer;
import be.fgov.ehealth.etee.crypto.encrypt.MessageSigner;
import be.fgov.ehealth.etee.crypto.encrypt.SignerInfoAttributesSender;
import be.fgov.ehealth.etee.crypto.encrypt.TripleWrapper;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPCheckerBuilder;
import be.fgov.ehealth.etee.crypto.policies.EncryptionPolicy;
import be.fgov.ehealth.etee.crypto.policies.KeyType;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPOptions;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import be.fgov.ehealth.etee.crypto.policies.SigningOption;
import be.fgov.ehealth.etee.crypto.policies.SigningOptions;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.utils.Iterables;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import be.fgov.ehealth.etee.crypto.utils.SecurityConfiguration;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSealerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSealerBuilder.class);
    private static CmsSignerFactory cmsSignerFactory = CmsSignerFactory.getInstance();

    private DataSealerBuilder() {
    }

    public static OCSPPolicyStep newBuilder() {
        SecurityConfiguration.configure();
        return new Steps();
    }

    static void setCmsSignerFactory(CmsSignerFactory cmsSignerFactory) {
        DataSealerBuilder.cmsSignerFactory = cmsSignerFactory;
    }

    private static class Steps
    implements OCSPPolicyStep,
    SigningPolicyStep,
    PublicKeyEncryptionPolicyStep,
    SecretKeyEncryptionPolicyStep,
    BuildStep {
        private static final String DEFAULT_AUTH_ALIAS = "Authentication";
        private static final String DEFAULT_SIGN_ALIAS = "Signature";
        private OCSPPolicy ocspPolicy = OCSPPolicy.NONE;
        private Map<OCSPOption, Object> ocspOptions = OCSPOptions.create();
        private SigningPolicy signingPolicy;
        private SigningCredential innerSignatureCredential;
        private SigningCredential outerSignatureCredential;
        private EncryptionPolicy publicKeyEncryptionPolicy = EncryptionPolicy.KNOWN_RECIPIENT;
        private EncryptionPolicy secretKeyEncryptionPolicy = EncryptionPolicy.UNKNOWN_RECIPIENT;

        private Steps() {
        }

        @Override
        public DataSealer build() {
            OCSPOptions options = OCSPOptions.defaultOptions().set(OCSPOption.INJECT_RESPONSE, true).setAll(this.ocspOptions);
            OCSPChecker ocspChecker = OCSPCheckerBuilder.newBuilder().addOCSPPolicy(this.ocspPolicy, options).build();
            CmsEncrypter cmsEncryptor = new CmsEncrypter(this.publicKeyEncryptionPolicy, this.secretKeyEncryptionPolicy);
            SignerInfoAttributesSender signerInfoAttributesSender = new SignerInfoAttributesSender();
            if (!this.innerSignatureCredential.equals(this.outerSignatureCredential)) {
                CmsSigner innerCmsSigner = cmsSignerFactory.create(this.signingPolicy, this.innerSignatureCredential, ocspChecker, signerInfoAttributesSender);
                CmsSigner outerCmsSigner = cmsSignerFactory.create(this.signingPolicy, this.outerSignatureCredential, ocspChecker, signerInfoAttributesSender);
                return new TripleWrapper(cmsEncryptor, new MessageSigner(innerCmsSigner, outerCmsSigner));
            }
            return new TripleWrapper(cmsEncryptor, new MessageSigner(cmsSignerFactory.create(this.signingPolicy, this.outerSignatureCredential, ocspChecker, signerInfoAttributesSender)));
        }

        @Override
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy policy) {
            return this.addOCSPPolicy(policy, new HashMap<OCSPOption, Object>());
        }

        @Override
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy policy, Map<OCSPOption, Object> ocspOptions) {
            Preconditions.checkNotNull(policy, "OCSPPolicy cannot be null.");
            Preconditions.checkNotNull(ocspOptions, "OCSPOptions cannot be null.");
            this.ocspPolicy = policy == OCSPPolicy.NONE ? policy : OCSPPolicy.RECEIVER_OPTIONAL;
            this.ocspOptions = ocspOptions;
            return this;
        }

        @Override
        public PublicKeyEncryptionPolicyStep addSigningPolicy(SigningPolicy policy, KeyStore keyStore) {
            return this.addSigningPolicy(policy, keyStore, new HashMap<SigningOption, Object>());
        }

        @Override
        public PublicKeyEncryptionPolicyStep addSigningPolicy(SigningPolicy policy, KeyStore keyStore, Map<SigningOption, Object> signingOptions) {
            Preconditions.checkNotNull(keyStore, "The given key store can not be null");
            Preconditions.checkNotNull(signingOptions, "The given signingOptions can not be null");
            SigningOptions signingOptionsToUse = SigningOptions.defaultOptions().set(SigningOption.NON_REPUDIATION, Boolean.TRUE).setAll(signingOptions);
            try {
                this.innerSignatureCredential = this.retrieveSigningCredential(this.getSigningAlias(signingOptionsToUse, keyStore), keyStore, signingOptionsToUse.getString(SigningOption.SIGN_PW));
                this.outerSignatureCredential = this.retrieveSigningCredential(this.getAuthAlias(signingOptionsToUse, keyStore), keyStore, signingOptionsToUse.getString(SigningOption.AUTH_PW));
            }
            catch (KeyStoreException e) {
                throw new IllegalArgumentException("SigningCredential could not be loaded from keystore", e);
            }
            this.signingPolicy = this.validatePolicy(policy, this.outerSignatureCredential);
            return this;
        }

        @Override
        public PublicKeyEncryptionPolicyStep addSigningPolicy(SigningPolicy policy, SigningCredential signingCredential) {
            Preconditions.checkNotNull(signingCredential, "The given signing credential cannot be null");
            this.innerSignatureCredential = signingCredential;
            this.outerSignatureCredential = signingCredential;
            this.signingPolicy = this.validatePolicy(policy, this.outerSignatureCredential);
            return this;
        }

        @Override
        public PublicKeyEncryptionPolicyStep addSigningPolicy(SigningPolicy policy, SigningCredential signingCredential, SigningCredential authCredential) {
            Preconditions.checkNotNull(signingCredential, "The given signing credential cannot be null");
            Preconditions.checkNotNull(authCredential, "The given authentication credential cannot be null");
            this.innerSignatureCredential = signingCredential;
            this.outerSignatureCredential = authCredential;
            this.signingPolicy = this.validatePolicy(policy, this.outerSignatureCredential);
            return this;
        }

        @Override
        public SecretKeyEncryptionPolicyStep addPublicKeyPolicy(EncryptionPolicy encryptionPolicy) {
            this.publicKeyEncryptionPolicy = Preconditions.checkNotNull(encryptionPolicy, "Public key encryption policy cannot be null");
            return this;
        }

        @Override
        public BuildStep addSecretKeyPolicy(EncryptionPolicy encryptionPolicy) {
            this.secretKeyEncryptionPolicy = Preconditions.checkNotNull(encryptionPolicy, "Secret key encryption policy cannot be null");
            return this;
        }

        private SigningPolicy validatePolicy(SigningPolicy policy, SigningCredential signingCredential) {
            Preconditions.checkNotNull(policy, "The given signing policy can not be null");
            Preconditions.checkNotNull(signingCredential, "The given signing credential can not be null");
            return SigningPolicy.getPolicyByKeyType(policy, KeyType.from(signingCredential));
        }

        private String getSigningAlias(SigningOptions signingOptionsToUse, KeyStore keyStore) throws KeyStoreException {
            String alias = signingOptionsToUse.getString(SigningOption.SIGN_ALIAS);
            if (alias == null) {
                alias = DEFAULT_SIGN_ALIAS;
            }
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String ksAlias = aliases.nextElement();
                if (!ksAlias.equalsIgnoreCase(alias)) continue;
                return ksAlias;
            }
            return this.getAuthAlias(signingOptionsToUse, keyStore);
        }

        private String getAuthAlias(SigningOptions signingOptionsToUse, KeyStore keyStore) throws KeyStoreException {
            String alias = signingOptionsToUse.getString(SigningOption.AUTH_ALIAS);
            if (alias == null) {
                alias = DEFAULT_AUTH_ALIAS;
            }
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String ksAlias = aliases.nextElement();
                if (!ksAlias.equalsIgnoreCase(alias)) continue;
                return ksAlias;
            }
            throw new IllegalArgumentException("alias " + alias + " not available in keystore.");
        }

        private SigningCredential retrieveSigningCredential(String alias, KeyStore keyStore, String password) {
            try {
                Certificate[] c = keyStore.getCertificateChain(alias);
                Preconditions.checkNotNull(c, "The keystore does not contain a certificate chain with alias [" + alias + "]");
                X509Certificate[] certificateChain = (X509Certificate[])Arrays.copyOf(c, c.length, X509Certificate[].class);
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password != null ? password.toCharArray() : null);
                Preconditions.checkNotNull(privateKey, "The keystore does not contain a private key with alias [" + alias + "]");
                return SigningCredential.create(privateKey, Iterables.newList(certificateChain));
            }
            catch (KeyStoreException e) {
                throw new IllegalArgumentException("Invalid keystore. Cannot get signing credential from it.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Nu such algorithm. Cannot retrieve key [" + alias + "] from keystore.", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IllegalArgumentException("Invalid credentials. Cannot retrieve key [" + alias + "] from keystore.", e);
            }
        }
    }

    public static interface BuildStep {
        public DataSealer build();
    }

    public static interface SecretKeyEncryptionPolicyStep
    extends BuildStep {
        public BuildStep addSecretKeyPolicy(EncryptionPolicy var1);
    }

    public static interface PublicKeyEncryptionPolicyStep
    extends BuildStep {
        public SecretKeyEncryptionPolicyStep addPublicKeyPolicy(EncryptionPolicy var1);
    }

    public static interface SigningPolicyStep {
        public PublicKeyEncryptionPolicyStep addSigningPolicy(SigningPolicy var1, KeyStore var2);

        public PublicKeyEncryptionPolicyStep addSigningPolicy(SigningPolicy var1, KeyStore var2, Map<SigningOption, Object> var3);

        public PublicKeyEncryptionPolicyStep addSigningPolicy(SigningPolicy var1, SigningCredential var2);

        public PublicKeyEncryptionPolicyStep addSigningPolicy(SigningPolicy var1, SigningCredential var2, SigningCredential var3);
    }

    public static interface OCSPPolicyStep
    extends SigningPolicyStep {
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy var1);

        public SigningPolicyStep addOCSPPolicy(OCSPPolicy var1, Map<OCSPOption, Object> var2);
    }
}

