/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReader;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderException;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderFactory;
import be.fgov.ehealth.etee.crypto.decrypt.DataUnsealer;
import be.fgov.ehealth.etee.crypto.decrypt.DataUnsealerResult;
import be.fgov.ehealth.etee.crypto.decrypt.EnvelopedDataDecrypter;
import be.fgov.ehealth.etee.crypto.decrypt.EnvelopedDataDecrypterResult;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifier;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierData;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierResult;
import be.fgov.ehealth.etee.crypto.decrypt.UnsealUtils;
import be.fgov.ehealth.etee.crypto.policies.SignatureLayer;
import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.NotificationFatal;
import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripleUnwrapper
implements DataUnsealer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleUnwrapper.class);
    private final SignedDataVerifier innerSignedDataVerifier;
    private final SignedDataVerifier outerSignedDataVerifier;
    private final EnvelopedDataDecrypter envelopedDataDecrypter;

    TripleUnwrapper(SignedDataVerifier innerSignedDataVerifier, SignedDataVerifier outerSignedDataVerifier, EnvelopedDataDecrypter envelopedDataDecrypter) {
        this.envelopedDataDecrypter = envelopedDataDecrypter;
        this.innerSignedDataVerifier = innerSignedDataVerifier;
        this.outerSignedDataVerifier = outerSignedDataVerifier;
    }

    @Override
    public String getKekID(byte[] sealedData) {
        return UnsealUtils.getKekID(sealedData);
    }

    @Override
    public String getSubjectKeyIdentifier(byte[] sealedData) {
        return UnsealUtils.getSubjectKeyIdentifier(sealedData);
    }

    public DataUnsealerResult unseal(byte[] data) {
        return this.unwrapBytes(data, null, new SigningCredential[0]);
    }

    public DataUnsealerResult unseal(byte[] data, SigningCredential ... signers) {
        return this.unwrapBytes(data, null, signers);
    }

    public DataUnsealerResult unseal(byte[] data, SecretKey kek) {
        return this.unwrapBytes(data, kek, new SigningCredential[0]);
    }

    public DataUnsealerResult unseal(byte[] data, SecretKey kek, SigningCredential ... signers) {
        return this.unwrapBytes(data, kek, signers);
    }

    public DataUnsealerResult unseal(InputStream sealedData, OutputStream unsealedData, SecretKey kek) {
        return this.unwrapStream(sealedData, unsealedData, kek, new SigningCredential[0]);
    }

    public DataUnsealerResult unseal(InputStream sealedData, OutputStream unsealedData, SecretKey kek, SigningCredential ... signers) {
        return this.unwrapStream(sealedData, unsealedData, kek, signers);
    }

    public DataUnsealerResult unseal(InputStream sealedData, OutputStream unsealedData) {
        return this.unwrapStream(sealedData, unsealedData, null, new SigningCredential[0]);
    }

    public DataUnsealerResult unseal(InputStream sealedData, OutputStream unsealedData, SigningCredential ... signers) {
        return this.unwrapStream(sealedData, unsealedData, null, signers);
    }

    private DataUnsealerResult unwrapBytes(byte[] data, SecretKey kek, SigningCredential ... signers) {
        DataUnsealerResult unsealResult = new DataUnsealerResult();
        CryptoResult<SignedDataVerifierData> outerSignedDataVerificationResult = this.verifySignedData(data, SignatureLayer.OUTER, null, signers);
        unsealResult.copyNotifications(outerSignedDataVerificationResult);
        if (this.isFatal(outerSignedDataVerificationResult)) {
            return unsealResult;
        }
        EnvelopedDataDecrypterResult decryptResult = this.envelopedDataDecrypter.decryptData(outerSignedDataVerificationResult.getData().getContent(), kek);
        unsealResult.copyNotifications(decryptResult);
        if (this.isFatal(decryptResult)) {
            return unsealResult;
        }
        CryptoResult<SignedDataVerifierData> innerSignedDataVerificationResult = this.verifySignedData(Streams.getBytes((InputStream)decryptResult.getData()), SignatureLayer.INNER, outerSignedDataVerificationResult.getData(), signers);
        unsealResult.copyNotifications(innerSignedDataVerificationResult);
        if (this.isFatal(innerSignedDataVerificationResult)) {
            return unsealResult;
        }
        unsealResult.setAuthenticationCert(outerSignedDataVerificationResult.getData().getAuthenticationCert());
        unsealResult.setAuthenticationKeyIdentifier(outerSignedDataVerificationResult.getData().getAuthenticationKeyIdentifier());
        unsealResult.setSigningTime(outerSignedDataVerificationResult.getData().getSigningTime());
        unsealResult.setSignatureCert(innerSignedDataVerificationResult.getData().getSignatureCert());
        unsealResult.setSignatureKeyIdentifier(innerSignedDataVerificationResult.getData().getSignatureKeyIdentifier());
        unsealResult.setContent(innerSignedDataVerificationResult.getData().getContent());
        return unsealResult;
    }

    private DataUnsealerResult unwrapStream(InputStream sealedData, OutputStream unsealedData, SecretKey kek, SigningCredential ... signers) {
        DataUnsealerResult unsealResult = new DataUnsealerResult();
        CMSReader<InputStream> cmsOuterMsgReader = CMSReaderFactory.getInstance().createStreamReader();
        CMSReader<InputStream> cmsInnerMsgReader = CMSReaderFactory.getInstance().createStreamReader();
        CMSMessageContext<InputStream> cmsOuterMsgContext = new CMSMessageContext<InputStream>(sealedData);
        if ((unsealResult = this.readContent(unsealResult, cmsOuterMsgReader, cmsOuterMsgContext, SignatureLayer.OUTER, true)).getFatal() != null || cmsOuterMsgContext.getContentStream() == null) {
            return unsealResult;
        }
        EnvelopedDataDecrypterResult decryptResult = this.envelopedDataDecrypter.decryptData(cmsOuterMsgContext.getContentStream(), kek);
        unsealResult.copyNotifications(decryptResult);
        if (this.isFatal(decryptResult)) {
            return unsealResult;
        }
        CMSMessageContext<InputStream> cmsInnerMsgContext = new CMSMessageContext<InputStream>((InputStream)decryptResult.getData());
        if ((unsealResult = this.readContent(unsealResult, cmsInnerMsgReader, cmsInnerMsgContext, SignatureLayer.INNER, true)).getFatal() != null || cmsInnerMsgContext.getContentStream() == null) {
            return unsealResult;
        }
        Streams.copy(cmsInnerMsgContext.getContentStream(), unsealedData);
        unsealResult = this.readContent(unsealResult, cmsOuterMsgReader, cmsOuterMsgContext, SignatureLayer.OUTER, false);
        if (unsealResult.getFatal() != null) {
            return unsealResult;
        }
        CryptoResult<SignedDataVerifierData> outerSignedDataVerificationResult = this.outerSignedDataVerifier.verifySignedData(cmsOuterMsgContext, null, signers);
        unsealResult.copyNotifications(outerSignedDataVerificationResult);
        SignedDataVerifierData outerSignedDataVerifierData = outerSignedDataVerificationResult.getData();
        unsealResult.setAuthenticationCert(outerSignedDataVerifierData.getAuthenticationCert());
        unsealResult.setAuthenticationKeyIdentifier(outerSignedDataVerifierData.getAuthenticationKeyIdentifier());
        unsealResult = this.readContent(unsealResult, cmsInnerMsgReader, cmsInnerMsgContext, SignatureLayer.INNER, false);
        if (unsealResult.getFatal() != null) {
            return unsealResult;
        }
        CryptoResult<SignedDataVerifierData> innerSignedDataVerificationResult = this.innerSignedDataVerifier.verifySignedData(cmsInnerMsgContext, outerSignedDataVerifierData, signers);
        unsealResult.copyNotifications(innerSignedDataVerificationResult);
        if (innerSignedDataVerificationResult.getFatal() != null) {
            return unsealResult;
        }
        unsealResult.setAuthenticationCert(outerSignedDataVerifierData.getAuthenticationCert());
        unsealResult.setAuthenticationKeyIdentifier(outerSignedDataVerifierData.getAuthenticationKeyIdentifier());
        unsealResult.setSigningTime(outerSignedDataVerificationResult.getData().getSigningTime());
        unsealResult.setSignatureCert(innerSignedDataVerificationResult.getData().getSignatureCert());
        unsealResult.setSignatureKeyIdentifier(innerSignedDataVerificationResult.getData().getSignatureKeyIdentifier());
        unsealResult.setContent(innerSignedDataVerificationResult.getData().getContent());
        return unsealResult;
    }

    private DataUnsealerResult readContent(DataUnsealerResult unsealResult, CMSReader<InputStream> cmsMsgReader, CMSMessageContext<InputStream> cmsMsgContext, SignatureLayer signatureLayer, boolean signedContentOnly) {
        try {
            if (signedContentOnly) {
                cmsMsgReader.readSignedContent(cmsMsgContext);
            } else {
                cmsMsgReader.read(cmsMsgContext);
            }
        }
        catch (CMSReaderException e) {
            LOGGER.error("Error reading " + (Object)((Object)signatureLayer) + " signed data.", (Throwable)e);
            return new DataUnsealerResult(signatureLayer == SignatureLayer.OUTER ? NotificationFatal.getOuterFailureForMessage(e.getMessage()) : NotificationFatal.getInnerFailureForMessage(e.getMessage()));
        }
        return unsealResult;
    }

    private CryptoResult<SignedDataVerifierData> verifySignedData(byte[] data, SignatureLayer signatureLayer, SignedDataVerifierData signVerificationData, SigningCredential ... signers) {
        SignedDataVerifierResult signedDataVerificationResult;
        try {
            CMSReader<byte[]> cmsMsgReader = CMSReaderFactory.getInstance().createByteArrayReader();
            CMSMessageContext<byte[]> cmsMsgContext = new CMSMessageContext<byte[]>(data);
            cmsMsgReader.read(cmsMsgContext);
            signedDataVerificationResult = signatureLayer == SignatureLayer.OUTER ? this.outerSignedDataVerifier.verifySignedData(cmsMsgContext, signVerificationData, signers) : this.innerSignedDataVerifier.verifySignedData(cmsMsgContext, signVerificationData, signers);
        }
        catch (CMSReaderException e) {
            LOGGER.error("Error verifying " + (Object)((Object)signatureLayer) + " signed data.", (Throwable)e);
            signedDataVerificationResult = new SignedDataVerifierResult(signatureLayer == SignatureLayer.OUTER ? NotificationFatal.getOuterFailureForMessage(e.getMessage()) : NotificationFatal.getInnerFailureForMessage(e.getMessage()));
        }
        return signedDataVerificationResult;
    }

    private boolean isFatal(CryptoResult<SignedDataVerifierData> signedDataVerificationResult) {
        return signedDataVerificationResult.getFatal() != null || signedDataVerificationResult.getData().getContent() == null;
    }

    private boolean isFatal(EnvelopedDataDecrypterResult decryptResult) {
        return decryptResult.getFatal() != null || decryptResult.getData() == null;
    }
}

