/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.cert.CertPathCheckerBuilder;
import be.fgov.ehealth.etee.crypto.crl.CRLChecker;
import be.fgov.ehealth.etee.crypto.crl.CRLCheckerBuilder;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifier;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierFactory;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributesReceiver;
import be.fgov.ehealth.etee.crypto.decrypt.SigningTimeVerifier;
import be.fgov.ehealth.etee.crypto.decrypt.TimeStampTrustService;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPCheckerBuilder;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPOptions;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.policies.SigningOption;
import be.fgov.ehealth.etee.crypto.policies.SigningOptions;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.utils.Iterables;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class DataSealSteps {
    static final int[] NON_REPUDIATION_ACCEPTABLE_KEY_USAGES = new int[]{64};
    static final int[] DIGITAL_SIGNATURE_ACCEPTABLE_KEY_USAGES = new int[]{128, 64};
    private OCSPPolicy ocspPolicy = OCSPPolicy.NONE;
    private final Collection<SigningPolicy> signingPolicies = Iterables.newSet();
    private Map<OCSPOption, Object> ocspOptions = OCSPOptions.create();
    private Map<SigningOption, Object> signingOptions = SigningOptions.create();
    private final OCSPOptions ocspOptionsToUse = OCSPOptions.defaultOptions();
    private final SigningOptions signingOptionsToUse = SigningOptions.defaultOptions();
    private KeyStore trustStore;
    private CertPathChecker certPathChecker;
    private OCSPChecker ocspChecker;
    private CRLChecker crlChecker;
    private TimeStampTrustService timeStampTrustService;
    private SignerInfoAttributesReceiver signerInfoAttributesReceiver;
    private SignedDataVerifier outerSignedDataVerifier;

    DataSealSteps() {
    }

    void addConfig(OCSPPolicy policy, Map<OCSPOption, Object> ocspOptions) {
        Preconditions.checkNotNull(policy, "OCSPPolicy cannot be null.");
        Preconditions.checkNotNull(ocspOptions, "OCSPOptions cannot be null.");
        this.ocspPolicy = policy;
        this.ocspOptions = ocspOptions;
    }

    void addConfig(KeyStore keyStore, Map<SigningOption, Object> signingOptions, SigningPolicy ... signingPolicies) {
        Preconditions.checkNotNull(signingOptions, "SigningOptions cannot be null.");
        Preconditions.checkNotEmpty((Object[])signingPolicies, "SigningPolicies cannot be empty");
        this.trustStore = keyStore;
        this.signingOptions = signingOptions;
        for (SigningPolicy policy : signingPolicies) {
            this.signingPolicies.addAll(this.buildPolicySet(policy));
        }
    }

    private Set<SigningPolicy> buildPolicySet(SigningPolicy policy) {
        Preconditions.checkNotNull(policy, "The given signing policy can not be null");
        return SigningPolicy.getPolicySet(policy);
    }

    void processConfig() {
        this.ocspOptionsToUse.set(OCSPOption.TRUST_STORE, this.trustStore).setAll(this.ocspOptions);
        this.signingOptionsToUse.set(SigningOption.TSA_TRUST_STORE, this.trustStore).setAll(this.signingOptions);
        CertStore certStore = this.signingOptionsToUse.getCertStore(SigningOption.TSA_CERT_STORE);
        this.certPathChecker = CertPathCheckerBuilder.newBuilder().addTrustStore(this.trustStore).build();
        this.ocspChecker = OCSPCheckerBuilder.newBuilder().addOCSPPolicy(this.ocspPolicy, this.ocspOptionsToUse).build();
        this.crlChecker = CRLCheckerBuilder.newBuilder().addCertStore(certStore).build();
        this.initTimeStampService(this.certPathChecker, this.crlChecker, this.signingOptionsToUse);
        SigningTimeVerifier signingTimeVerifier = new SigningTimeVerifier(this.signingOptionsToUse, this.timeStampTrustService);
        this.signerInfoAttributesReceiver = new SignerInfoAttributesReceiver();
        this.outerSignedDataVerifier = SignedDataVerifierFactory.getInstance().createOuterSignedDataVerifier(this.signingPolicies, DIGITAL_SIGNATURE_ACCEPTABLE_KEY_USAGES, this.ocspChecker, this.certPathChecker, this.signerInfoAttributesReceiver, signingTimeVerifier);
    }

    private void initTimeStampService(CertPathChecker certPathChecker, CRLChecker crlChecker, SigningOptions signingOptionsToUse) {
        KeyStore tsaTrustStore = signingOptionsToUse.getKeyStore(SigningOption.TSA_TRUST_STORE);
        if (tsaTrustStore != null) {
            CertPathChecker tsaCertPathChecker = CertPathCheckerBuilder.newBuilder().addTrustStore(tsaTrustStore).build();
            this.timeStampTrustService = new TimeStampTrustService(tsaTrustStore, crlChecker, tsaCertPathChecker);
        } else {
            this.timeStampTrustService = new TimeStampTrustService(this.trustStore, crlChecker, certPathChecker);
        }
    }

    SignedDataVerifier getOuterSignedDataVerifier() {
        return this.outerSignedDataVerifier;
    }

    SignerInfoAttributesReceiver getSignerInfoAttributesReceiver() {
        return this.signerInfoAttributesReceiver;
    }

    TimeStampTrustService getTimeStampTrustService() {
        return this.timeStampTrustService;
    }

    OCSPOptions getOcspOptionsToUse() {
        return this.ocspOptionsToUse;
    }

    Collection<SigningPolicy> getSigningPolicies() {
        return this.signingPolicies;
    }

    CertPathChecker getCertPathChecker() {
        return this.certPathChecker;
    }

    OCSPChecker getOcspChecker() {
        return this.ocspChecker;
    }

    OCSPPolicy getOcspPolicy() {
        return this.ocspPolicy;
    }

    Map<OCSPOption, Object> getOcspOptions() {
        return this.ocspOptions;
    }

    Map<SigningOption, Object> getSigningOptions() {
        return this.signingOptions;
    }

    SigningOptions getSigningOptionsToUse() {
        return this.signingOptionsToUse;
    }

    KeyStore getTrustStore() {
        return this.trustStore;
    }

    CRLChecker getCrlChecker() {
        return this.crlChecker;
    }
}

