/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import org.mockserver.model.Not;

public abstract class Body<T>
extends Not {
    private final Type type;
    protected final MediaType contentType;

    public Body(Type type, MediaType contentType) {
        this.type = type;
        this.contentType = contentType;
    }

    public Type getType() {
        return this.type;
    }

    public abstract T getValue();

    @JsonIgnore
    public byte[] getRawBytes() {
        return this.toString().getBytes();
    }

    @JsonIgnore
    Charset determineCharacterSet(MediaType contentType, Charset defaultCharset) {
        if (contentType != null && contentType.charset().isPresent()) {
            return (Charset)contentType.charset().get();
        }
        return defaultCharset;
    }

    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        return this.determineCharacterSet(this.contentType, defaultIfNotSet);
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    public static enum Type {
        PARAMETERS,
        XPATH,
        XML,
        JSON,
        JSON_SCHEMA,
        REGEX,
        STRING,
        BINARY;

    }
}

