﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.util;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.mappers;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.technicalconnector.config.util.domain;
using be.ehealth.technicalconnector.handler.domain;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using java.io;
using java.lang;
using java.util;
using java.net;
using NUnit.Framework;
using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.cin.nip.async.business;
using be.ehealth.businessconnector.genericasync.session;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.businessconnector.genericasync.test.helper;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.business.mycarenetdomaincommons.mapper;
using org.apache.commons.collections;
using org.slf4j;
using be.ehealth.businessconnector.test.testcommons.utils;


namespace be.ehealth.businessconnector.geninsasync.session
{
	
	/**
     * <p>Tests to check and document the asynchronous call flow of the operations get and confirm of the genins service.<p>
     * 
     * <p>Not that the MediPrima service works with message id references (not with hashes).</p>
     * 
     * <p>The business content of the returned invoicing files is not checked.</p>
     *
     * @author EHP
     */
	[TestFixture]
	public class GenInsGetAndConfirmInvoicingGenericAsyncIntegrationTest
	{
		private static Logger LOG = LoggerFactory.getLogger(typeof(GenInsGetAndConfirmInvoicingGenericAsyncIntegrationTest));
				
		private static string PROJECT_NAME = "genins";
    	private static string OUTPUT_FILE_EXTENSION = ".txt";
        private static string OUTPUT_DIR = "geninsSendFiles";

        private static int MAX_MESSAGES = 100;
        
        private static java.util.List messageNames = java.util.Arrays.asList("INSX");
        
        private static GetAndConfirmTestHelper testHelper;

        
    
		[SetUp]
	    public static void init() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.geninsasync.test.properties",SupportedLanguages.NET.getAbbreviation());
	    	testHelper = GetAndConfirmTestHelper.builder()
                                    .withProjectName(PROJECT_NAME)
                                    .withMessageNames(messageNames)
                                    .withMaxMessages(MAX_MESSAGES)
                                    .withOutputFileExtension(OUTPUT_FILE_EXTENSION)
                                    .withOutputDir(OUTPUT_DIR)
                                    .BusinessResponseValidator(new BusinessResponseValidatorImpl())
                                    .build();
		}
	
	    [TearDown]
	    public static void tearDown() {
	        Session.getInstance().unloadSession();
	    }
    
	   
            
        [Test]
        public void getTest() {
            GetResponse response = testHelper.performGetAndConfirm(false);
            response.getReturn().getMsgResponses();
        }
    
        [Test]
        public void getAndConfirmTest() {
            testHelper.performGetAndConfirm(true);
        }
    
    
        /**
         * To run this test, supply a list of TAckResponse references you want ensure they are no longer returned
         * by the service (typically, after confirming TAck responses).
         */
        [Test]
        public void checkIfTAckResponsesWithSameReferencesAreStillReturned() {
    
            // Add your own references to be verified
            java.util.List tAckResponseReferences = Arrays.asList();
    
            testHelper.checkIfTAckResponsesWithSameReferencesAreStillReturned(tAckResponseReferences);
        }
    
        [Test]
        public void checkIfMessagesWithSameReferencesAreStillReturned() {
    
            // Add your own references to be verified
            java.util.List msgResponseReferences = Arrays.asList();
    
            testHelper.checkIfMessagesWithSameReferencesAreStillReturned(msgResponseReferences);
        }
        
        private class BusinessResponseValidatorImpl : GetAndConfirmTestHelper.BusinessResponseValidator {
            public void validate(string blobValue)
            {
                GenericResponseList genericResponseList = (GenericResponseList) ConnectorXmlUtils.toObject(blobValue, typeof(GenericResponseList));
                ConnectorXmlUtils.dump(genericResponseList);
                Assert.IsTrue(genericResponseList != null && CollectionUtils.isNotEmpty(genericResponseList.getGenericResponses()), "Business reponse should contain at least one genericResponse");
            }
        }
	}
}
