/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ForwardingMap<K, V>
implements Map<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardingMap.class);

    ForwardingMap() {
    }

    protected abstract Map<K, V> delegate();

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate().get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate().putAll(m);
    }

    @Override
    public void clear() {
        this.delegate().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate().entrySet();
    }

    protected <A> A valueOf(Object key, Class<A> targetType) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isAssignableFrom(targetType)) {
            return (A)value;
        }
        try {
            Method valueOfMethod = this.getValueOfMethod(targetType, value.getClass());
            if (!this.isAssignableParam(value, valueOfMethod)) {
                value = this.getAssignableValue(value, valueOfMethod);
            }
            return (A)valueOfMethod.invoke(null, value);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to assign value [" + value + "] of key [" + key + "] to type [" + targetType + "]", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected type [" + targetType + "] for value of key [" + key + "] is not assignable from given type [" + value.getClass() + "]", e);
        }
    }

    private <A> Method getValueOfMethod(Class<A> targetType, Class<?> sourceType) throws NoSuchMethodException {
        Class[] paramTypes;
        for (Class paramType : paramTypes = new Class[]{sourceType, String.class, Object.class}) {
            try {
                return targetType.getMethod("valueOf", paramType);
            }
            catch (SecurityException e) {
                LOGGER.trace("Failed to get method. Try next.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.trace("No such method. Try next.", (Throwable)e);
            }
        }
        throw new NoSuchMethodException("Target type [" + targetType + "] does not support a valueOf method for source type [" + sourceType + "]");
    }

    private boolean isAssignableParam(Object value, Method valueOfMethod) {
        Class<Object> paramClass = valueOfMethod.getParameterTypes()[0];
        return paramClass.isAssignableFrom(Object.class) || value.getClass().isAssignableFrom(paramClass);
    }

    private Object getAssignableValue(Object value, Method valueOfMethod) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method bridge = this.getValueOfMethod(valueOfMethod.getParameterTypes()[0], value.getClass());
        return bridge.invoke(null, value);
    }
}

