/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.therlink.builders.impl;

import be.ehealth.business.common.util.BeIDInfoUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.businessconnector.therlink.builders.ProofBuilder;
import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.therlink.domain.Proof;
import be.ehealth.businessconnector.therlink.domain.ProofTypeValues;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;

import java.util.HashMap;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;


/**
 * Integration test for {@link ProofBuilder} (requires eid card and pin code input)
 * 
 * @author EHP
 * 
 */
public class ProofBuilderImplUserIntegrationTest {

    private static final String SIGNATURE = "Signature";

    @BeforeClass
    public static void init() throws Exception {
        AssumeTools.isEIDEnabled();
        SessionInitializer.init("/be.ehealth.businessconnector.therlink.test.properties", true);
    }

    @Test
    public void createEidSigningProof() throws Exception {
        ConfigFactory.getConfigValidator().getConfig();
        String nissEid =  BeIDInfoUtil.getBeIDInfo("tests").getIdentity().getNationalNumber();
        Credential cred = BeIDCredential.getInstance(nissEid, SIGNATURE);
        Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForEidSigning(cred);

        // 3. Validation of the signature
        SignatureVerificationResult result = SignatureBuilderFactory.getSignatureBuilder(AdvancedElectronicSignatureEnumeration.CAdES).verify(proof.getBinaryProof().getBinary(), new HashMap<String, Object>());

        if (!result.isValid()) {
            Assert.fail("Validation error : " + result);
        }

        assertEquals(ProofTypeValues.EIDSIGNING.getValue(), proof.getType());
        assertNotNull(proof.getBinaryProof());
        assertEquals("CMS", proof.getBinaryProof().getMethod());
    }
}
