/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.domain;

import be.ehealth.technicalconnector.handler.CacheFeederHandler;
import be.ehealth.technicalconnector.handler.ConnectionTimeOutHandler;
import be.ehealth.technicalconnector.handler.FromHandler;
import be.ehealth.technicalconnector.handler.LoggingHandler;
import be.ehealth.technicalconnector.handler.MessageLevelRetryHandler;
import be.ehealth.technicalconnector.handler.UserAgentHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.ws.handler.Handler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HandlersLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HandlersLoader.class);
    private static List<Class> defaultHandlers = Arrays.asList(MessageLevelRetryHandler.class, ConnectionTimeOutHandler.class, LoggingHandler.class, UserAgentHandler.class, FromHandler.class, CacheFeederHandler.class);

    private HandlersLoader() {
    }

    static Handler[] addingDefaultHandlers(Handler[] result) {
        ArrayList<Class> requiredHandler = new ArrayList<Class>(defaultHandlers.size());
        requiredHandler.addAll(defaultHandlers);
        CollectionUtils.filter(requiredHandler, (Predicate)new DefaultHandlersPredicate(result));
        for (Class handler : requiredHandler) {
            try {
                LOG.debug("Adding required handler [{}]", (Object)handler.getName());
                result = (Handler[])ArrayUtils.add((Object[])result, handler.newInstance());
            }
            catch (Exception e) {
                LOG.warn("Unable to add required handler", (Throwable)e);
            }
        }
        return result;
    }

    private static class DefaultHandlersPredicate
    implements Predicate {
        private Class<?>[] handlers;

        public DefaultHandlersPredicate(Handler<?>[] handlers) {
            HashSet handlerSet = new HashSet();
            for (Handler<?> handler : handlers) {
                handlerSet.add(handler.getClass());
            }
            this.handlers = handlerSet.toArray(new Class[handlerSet.size()]);
        }

        public boolean evaluate(Object object) {
            return !ArrayUtils.contains((Object[])this.handlers, (Object)object);
        }
    }
}

