/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.action;

import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SAMLTokenSignedAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLTokenSignedAction.class);

    @Override
    public void execute(WSHandler handler, SecurityActionToken actionToken, Document doc, RequestData reqData) throws WSSecurityException {
        Crypto crypto;
        block13: {
            crypto = null;
            try {
                crypto = handler.loadSignatureCrypto(reqData);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        CallbackHandler samlCallbackHandler = handler.getCallbackHandler("samlCallbackClass", "samlCallbackRef", reqData);
        if (samlCallbackHandler == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noSAMLCallbackHandler");
        }
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)samlCallbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        if (samlCallback.isSignAssertion()) {
            samlAssertion.signAssertion(samlCallback.getIssuerKeyName(), samlCallback.getIssuerKeyPassword(), samlCallback.getIssuerCrypto(), samlCallback.isSendKeyValue(), samlCallback.getCanonicalizationAlgorithm(), samlCallback.getSignatureAlgorithm(), samlCallback.getSignatureDigestAlgorithm());
        }
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(reqData.getWssConfig());
        CallbackHandler callbackHandler = handler.getPasswordCallbackHandler(reqData);
        WSPasswordCallback passwordCallback = handler.getPasswordCB(reqData.getUsername(), 16, callbackHandler, reqData);
        wsSign.setUserInfo(reqData.getUsername(), passwordCallback.getPassword());
        SignatureActionToken signatureToken = null;
        if (actionToken instanceof SignatureActionToken) {
            signatureToken = (SignatureActionToken)actionToken;
        }
        if (signatureToken == null) {
            signatureToken = reqData.getSignatureToken();
        }
        if (signatureToken.getKeyIdentifierId() != 0) {
            wsSign.setKeyIdentifierType(signatureToken.getKeyIdentifierId());
        }
        if (signatureToken.getSignatureAlgorithm() != null) {
            wsSign.setSignatureAlgorithm(signatureToken.getSignatureAlgorithm());
        }
        if (signatureToken.getDigestAlgorithm() != null) {
            wsSign.setDigestAlgo(signatureToken.getDigestAlgorithm());
        }
        if (signatureToken.getC14nAlgorithm() != null) {
            wsSign.setSigCanonicalization(signatureToken.getC14nAlgorithm());
        }
        if (signatureToken.getParts().size() > 0) {
            wsSign.setParts(signatureToken.getParts());
        }
        try {
            wsSign.build(doc, crypto, samlAssertion, samlCallback.getIssuerCrypto(), samlCallback.getIssuerKeyName(), samlCallback.getIssuerKeyPassword(), reqData.getSecHeader());
            reqData.getSignatureValues().add(wsSign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "empty", new Object[]{"Error when signing the SAML token: "});
        }
    }
}

