/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink.builders.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.therlink.domain.Proof;
import be.ehealth.businessconnector.therlink.domain.ProofTypeValues;


/**
 * Integration test for {@link ProofBuilder}
 * 
 * @author Priscilla Colleaux
 * 
 */
public class ProofBuilderImplTest {

    @Test
    public void createEidReadingProof() throws Exception {
        Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForEidReading();

        assertEquals(ProofTypeValues.EIDREADING.getValue(), proof.getType());
        assertNull(proof.getBinaryProof());
    }

    @Test
    public void createSisReadingProof() throws Exception {
        Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForSisReading();
        assertEquals(ProofTypeValues.SISREADING.getValue(), proof.getType());
        assertNull(proof.getBinaryProof());
    }

    @Test
    public void createIsiReadingProof() throws Exception {
        Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForIsiReading();
        assertEquals(ProofTypeValues.ISIREADING.getValue(), proof.getType());
        assertNull(proof.getBinaryProof());
    }


}
