/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.addressbook.integration;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.businessconnector.addressbook.service.AddressbookTokenService;
import be.ehealth.businessconnector.addressbook.service.impl.AddressbookTokenServiceImpl;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.validator.impl.EhealthReplyValidatorImpl;
import be.ehealth.technicalconnector.validator.impl.SAMLSessionValidator;
import be.fgov.ehealth.addressbook.protocol.v1.GetOrganizationContactInfoRequest;
import be.fgov.ehealth.addressbook.protocol.v1.GetOrganizationContactInfoResponse;
import be.fgov.ehealth.addressbook.protocol.v1.GetProfessionalContactInfoRequest;
import be.fgov.ehealth.addressbook.protocol.v1.GetProfessionalContactInfoResponse;
import be.fgov.ehealth.addressbook.protocol.v1.SearchOrganizationsRequest;
import be.fgov.ehealth.addressbook.protocol.v1.SearchOrganizationsResponse;
import be.fgov.ehealth.addressbook.protocol.v1.SearchProfessionalsRequest;
import be.fgov.ehealth.addressbook.protocol.v1.SearchProfessionalsResponse;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;

/**
 * Integration test for addressbook with session
 * 
 * @author EHP
 *
 */
public class AddressbookTokenIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build();

    private static SAMLToken token;

    @BeforeClass
    public static void setSAMLTokenAndConfig() throws Exception, TechnicalConnectorException {
        token = Session.getInstance().getSession().getSAMLToken();
        Session.getInstance().unloadSession();
    }

    @Test
    public void getOrganizationContactInfoTest() throws Exception {
        verifySession();

        GetOrganizationContactInfoRequest request = AddressbookTestUtils.createGetOrganizationContactInfoRequest();
        AddressbookTokenService service = new AddressbookTokenServiceImpl(new SAMLSessionValidator(), new EhealthReplyValidatorImpl());

        GetOrganizationContactInfoResponse response = service.getOrganizationContactInfo(token, request);
        AddressbookTestUtils.verifyResponseGetOrganizationContactInfo(response);
    }

    @Test
    public void getProfessionalContactInfoTest() throws Exception {
        verifySession();

        GetProfessionalContactInfoRequest request = AddressbookTestUtils.createGetProfessionalContactInfo();
        AddressbookTokenService service = new AddressbookTokenServiceImpl(new SAMLSessionValidator(), new EhealthReplyValidatorImpl());

        GetProfessionalContactInfoResponse response = service.getProfessionalContactInfo(token, request);
        AddressbookTestUtils.verifyResponseGetProfessionalContactInfo(response);
    }

    @Test
    public void searchOrganizationsTest() throws Exception {
        verifySession();

        SearchOrganizationsRequest request = AddressbookTestUtils.createSearchOrganizationsRequest();
        AddressbookTokenService service = new AddressbookTokenServiceImpl(new SAMLSessionValidator(), new EhealthReplyValidatorImpl());

        SearchOrganizationsResponse response = service.searchOrganizations(token, request);
        AddressbookTestUtils.verifySearchOrganizationsResponse(response);
    }

    @Test
    public void searchProfessionalsTest() throws Exception {
        verifySession();

        SearchProfessionalsRequest request = AddressbookTestUtils.createSearchProfessionalsRequest();

        AddressbookTokenService service = new AddressbookTokenServiceImpl(new SAMLSessionValidator(), new EhealthReplyValidatorImpl());

        SearchProfessionalsResponse response = service.searchProfessionals(token, request);
        AddressbookTestUtils.verifySearchProfessionalsResponse(response);
    }

    private void verifySession() throws SessionManagementException {
        if (Session.getInstance().hasValidSession()) {
            Assert.fail("A session is valid when we don't want to have one.");
        }
    }

}
