/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.sso;

import be.ehealth.technicalconnector.enumeration.SsoProfile;
import be.ehealth.technicalconnector.service.ServiceFactory;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import java.net.URI;


/**
 * IntegrationTest for the {@link SingleSignOnService}
 *
 * @author EHP
 */
public class SingleSignOnServiceTest {

    private static String relayState = "https://wwwacc.ehealth.fgov.be/nl/beroepsbeoefenaars-in-de-gezondheidszorg";

    private SingleSignOnService sso;

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().build();

    public static class TestBrowser implements BrowserHandler {

        @Override
        public void browse(URI uri) {
            Assert.assertNotNull(uri);
        }
    }

    @Before
    public void init() throws Exception {
        sso = ServiceFactory.getSingleSignOnService();
        sso.setHandler(new TestBrowser());
    }

    @Test
    public void withSAML2Artifact() throws Exception {
        sso.signin(SsoProfile.SAML2_ARTIFACT, relayState);
    }

    @Test
    public void withSAML2ArtifactWithoutRelayState() throws Exception {
        sso.signin(SsoProfile.SAML2_ARTIFACT);
    }

    @Test
    public void withSAML2POST() throws Exception {
        sso.signin(SsoProfile.SAML2_POST, relayState);
    }

    @Test
    public void withSAML2POSTWithoutRelayState() throws Exception {
        sso.signin(SsoProfile.SAML2_POST);
    }
}
