/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.etee.impl;

import java.security.KeyStore;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.technicalconnector.service.etee.CryptoFactory;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * Class to test the behaviour of {@link ConnectorRevocationStatusChecker}
 * 
 * @author EHP
 */
public class ConnectorRevocationStatusCheckerUserIntegrationTest  {

    private static final String INSTANCE_NAME = "test";

    @ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession().build();

  
    @Before
    public void before() throws Exception {
        KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
        store.setCertificateEntry("ca", BeIDCredential.getInstance(INSTANCE_NAME, BeIDCredential.EID_AUTH_ALIAS).getCertificateChain()[1]);
        store.setCertificateEntry("ca2", BeIDCredential.getInstance(INSTANCE_NAME, BeIDCredential.EID_AUTH_ALIAS).getCertificateChain()[2]);
    }


    @After
    public void after() throws Exception {
        KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
        store.deleteEntry("ca");
        store.deleteEntry("ca2"); 
    }

    @Test
    public void testWithEid() throws Exception {
        ConnectorRevocationStatusChecker checker = new ConnectorRevocationStatusChecker();
        boolean isRevoked = checker.isRevoked(BeIDCredential.getInstance(INSTANCE_NAME, BeIDCredential.EID_AUTH_ALIAS).getCertificate());
        Assert.assertFalse(isRevoked);
    }

}
