/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.cache.impl;

import be.ehealth.technicalconnector.cache.Cache;
import be.ehealth.technicalconnector.cache.CacheFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.handler.CacheFeederHandler;
import be.ehealth.technicalconnector.shutdown.ShutdownHook;
import be.ehealth.technicalconnector.shutdown.ShutdownRegistry;
import be.ehealth.technicalconnector.utils.ConfigurableImplementation;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.apache.commons.io.IOUtils;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR107Cache<K, V>
implements Cache<K, V>,
ConfigurableImplementation,
ShutdownHook {
    private static final Logger LOG = LoggerFactory.getLogger(JSR107Cache.class);
    private javax.cache.Cache<K, V> cache;
    private CacheManager cacheManager;

    @Override
    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        try {
            String serviceName = (String)parameterMap.get("cacheName");
            CacheFactory.ExpiryType expiryType = (CacheFactory.ExpiryType)((Object)parameterMap.get("cacheExpiryType"));
            Duration expiryDuration = (Duration)parameterMap.get("cacheExpiryDuration");
            URI cacheConfig = null;
            switch (expiryType) {
                case NONE: {
                    cacheConfig = CacheFeederHandler.class.getResource("/jsr107/ehcache-expiry-none.xml").toURI();
                    break;
                }
                case TTL: {
                    String xml = ConnectorIOUtils.getResourceAsString("/jsr107/ehcache-expiry-ttl.xml").replaceAll("${expiry.ttl}", "" + expiryDuration.getMillis());
                    File configFile = ConnectorIOUtils.createTempFile("ehcache-expiry-ttl.xml");
                    IOUtils.write((String)xml, (Writer)new FileWriter(configFile));
                    cacheConfig = configFile.toURI();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported expiry" + (Object)((Object)expiryType));
                }
            }
            this.cacheManager = Caching.getCachingProvider().getCacheManager(cacheConfig, JSR107Cache.class.getClassLoader());
            this.cache = this.cacheManager.getCache(serviceName, String.class, String.class);
            if (this.cache == null) {
                MutableConfiguration configuration = new MutableConfiguration().setStoreByValue(true).setStatisticsEnabled(true).setTypes(String.class, String.class);
                this.cache = this.cacheManager.createCache(serviceName, (Configuration)configuration);
            }
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "unable to instantiate JSR107 cache", e);
        }
        ShutdownRegistry.register(this);
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public V get(K key) {
        return (V)this.cache.get(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.cache.putAll(map);
    }

    @Override
    public void shutdown() {
        this.cacheManager.close();
    }
}

