/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class KeyManager {
    private static final Logger LOGGER = Logger.getLogger(KeyManager.class);
    private static final int DIGITAL_SIGNATURE = 0;
    private static final int NON_REPUDIATION = 1;
    private static final int KEY_ENCIPHERMENT = 2;
    private static final int DATA_ENCIPHERMENT = 3;
    private static final int KEY_AGREEMENT = 4;
    private static final int KEYCERT_SIGN = 5;
    private static final int CRL_SIGN = 6;
    private static final int ENCIPHER_ONLY = 7;
    private static final int DECIPHER_ONLY = 8;

    private KeyManager() {
    }

    public static KeyStore getKeyStore(String privateKeyStoreType) {
        try {
            return KeyManager.getKeyStore((InputStream)null, privateKeyStoreType, null);
        }
        catch (Exception exception) {
            throw new KeyStoreOpeningException(exception);
        }
    }

    public static KeyStore getKeyStore(File privateKeyStoreFile, String privateKeyStoreType, char[] privateKeyStorePassword) throws CertificateException, IOException {
        if (privateKeyStoreFile != null && privateKeyStoreFile.exists()) {
            return KeyManager.getKeyStore(new FileInputStream(privateKeyStoreFile), privateKeyStoreType, privateKeyStorePassword);
        }
        return KeyManager.getKeyStore((InputStream)null, privateKeyStoreType, privateKeyStorePassword);
    }

    public static KeyStore getKeyStore(String keystorePath, String keystoreType, char[] keystorePassword) {
        try {
            return KeyManager.getKeyStore(new FileInputStream(keystorePath), keystoreType, keystorePassword);
        }
        catch (Exception exception) {
            throw new KeyStoreOpeningException("Keystore with path '" + keystorePath + "' could not be loaded: " + exception.getMessage(), exception);
        }
    }

    public static KeyStore getKeyStore(InputStream keyStoreIS, String keyStoreType, char[] keyStorePassword) throws CertificateException, IOException {
        try {
            KeyStore privateKeyStore = KeyStore.getInstance(keyStoreType);
            privateKeyStore.load(keyStoreIS, keyStorePassword);
            return privateKeyStore;
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreOpeningException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreOpeningException(noSuchAlgorithmException);
        }
    }

    public static void emptyKeyStore(File keyStoreFile, String keyStoreType, char[] keyStorePassword) throws CertificateException, IOException {
        try {
            KeyStore keyStore = KeyManager.getKeyStore(keyStoreFile, keyStoreType, keyStorePassword);
            String alias = null;
            Enumeration<String> en = keyStore.aliases();
            while (en.hasMoreElements()) {
                alias = en.nextElement();
                keyStore.deleteEntry(alias);
            }
            FileOutputStream fos = new FileOutputStream(keyStoreFile);
            keyStore.store(fos, keyStorePassword);
            fos.flush();
            fos.close();
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreOpeningException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreOpeningException(noSuchAlgorithmException);
        }
    }

    public static CertStore getCertStore(Collection<?> certsAndCrls) {
        try {
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(certsAndCrls));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertStoreException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertStoreException(e);
        }
    }

    public static PrivateKey getKey(KeyStore privateKeyStore, String privateKeyAlias, char[] privateKeyPassword) throws UnrecoverableKeyException {
        try {
            return (PrivateKey)privateKeyStore.getKey(privateKeyAlias, privateKeyPassword);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreOpeningException(e);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreOpeningException(e);
        }
    }

    public static PrivateKey getKey(File privateKeyStoreFile, String privateKeyStoreType, char[] privateKeyStorePassword, String privateKeyAlias, char[] privateKeyPassword) throws IOException, CertificateException, UnrecoverableKeyException {
        KeyStore privateKeyStore = KeyManager.getKeyStore(privateKeyStoreFile, privateKeyStoreType, privateKeyStorePassword);
        return KeyManager.getKey(privateKeyStore, privateKeyAlias, privateKeyPassword);
    }

    public static PrivateKey getKey(InputStream privateKeyStoreFile, String privateKeyStoreType, char[] privateKeyStorePassword, String privateKeyAlias, char[] privateKeyPassword) throws CertificateException, IOException, UnrecoverableKeyException {
        KeyStore privateKeyStore = KeyManager.getKeyStore(privateKeyStoreFile, privateKeyStoreType, privateKeyStorePassword);
        LOGGER.debug((Object)("key store found : " + privateKeyStore.toString()));
        return KeyManager.getKey(privateKeyStore, privateKeyAlias, privateKeyPassword);
    }

    public static Map<String, PrivateKey> getDecryptionKeys(KeyStore privateKeyStore, char[] privateKeyPassword) {
        try {
            HashMap<String, PrivateKey> keys = new HashMap<String, PrivateKey>();
            Enumeration<String> aliases = privateKeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                PrivateKey privateKey = KeyManager.getDecryptionKey(privateKeyStore, privateKeyPassword, alias);
                if (privateKey == null) continue;
                keys.put(alias, privateKey);
            }
            return keys;
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreOpeningException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreOpeningException(noSuchAlgorithmException);
        }
    }

    private static PrivateKey getDecryptionKey(KeyStore privateKeyStore, char[] privateKeyPassword, String alias) throws KeyStoreException, NoSuchAlgorithmException {
        if (privateKeyStore.isKeyEntry(alias)) {
            try {
                PrivateKey privateKey = (PrivateKey)privateKeyStore.getKey(alias, privateKeyPassword);
                X509Certificate cert = (X509Certificate)privateKeyStore.getCertificate(alias);
                if ((KeyManager.getKeyUsage(cert) & 0x30) == 48) {
                    LOGGER.debug((Object)("private key found for keystore alias : " + alias));
                    return privateKey;
                }
            }
            catch (UnrecoverableKeyException privateKeyNotFound) {
                LOGGER.warn((Object)("private key not found for keystore alias [" + alias + "] with given password."), (Throwable)privateKeyNotFound);
            }
        }
        return null;
    }

    public static KeyStore.PrivateKeyEntry getKeyAndCertificates(KeyStore privateKeyStore, String privateKeyAlias, char[] privateKeyPassword) throws UnrecoverableKeyException {
        try {
            PrivateKey privateKey = (PrivateKey)privateKeyStore.getKey(privateKeyAlias, privateKeyPassword);
            Certificate[] certs = privateKeyStore.getCertificateChain(privateKeyAlias);
            return new KeyStore.PrivateKeyEntry(privateKey, certs);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreOpeningException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreOpeningException(noSuchAlgorithmException);
        }
    }

    public static PrivateKey getKey(File privateKeyFile) throws IOException, InvalidKeySpecException {
        FileInputStream privateKeyStream = new FileInputStream(privateKeyFile);
        byte[] encoded = new byte[privateKeyStream.available()];
        privateKeyStream.read(encoded);
        privateKeyStream.close();
        KeyFactory kf = null;
        try {
            kf = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreOpeningException("The default security provider hasn't been configured yet. Please execute SecurityConfiguration.configure()", e);
        }
        return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
    }

    public static X509Certificate getCertificate(KeyStore privateKeyStore, String privateKeyAlias) {
        try {
            return (X509Certificate)privateKeyStore.getCertificate(privateKeyAlias);
        }
        catch (KeyStoreException keyStoreException) {
            throw new CertificateRetrievalException(keyStoreException);
        }
    }

    public static X509Certificate getCertificate(InputStream certificateInputstream) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(certificateInputstream);
        try {
            certificateInputstream.close();
        }
        catch (IOException e) {
            throw new CertificateRetrievalException(e);
        }
        return (X509Certificate)cert;
    }

    public static X509Certificate getCertificate(File certificateFile) throws CertificateException, FileNotFoundException {
        return KeyManager.getCertificate(new FileInputStream(certificateFile));
    }

    public static X509Certificate[] getCertificateChain(KeyStore privateKeyStore, String privateKeyAlias) {
        try {
            Certificate[] certificateChain = privateKeyStore.getCertificateChain(privateKeyAlias);
            int length = certificateChain.length;
            X509Certificate[] certificates = new X509Certificate[length];
            for (int i = 0; i < length; ++i) {
                certificates[i] = (X509Certificate)certificateChain[i];
            }
            return certificates;
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static List<X509Certificate> getCertificates(File privateKeyStoreFile, String privateKeyStoreType, char[] privateKeyStorePassword) throws CertificateException, IOException {
        KeyStore privateKeyStore = KeyManager.getKeyStore(privateKeyStoreFile, privateKeyStoreType, privateKeyStorePassword);
        return KeyManager.getCertificates(privateKeyStore);
    }

    public static List<X509Certificate> getCertificates(KeyStore privateKeyStore) {
        try {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            String alias = null;
            Enumeration<String> en = privateKeyStore.aliases();
            while (en.hasMoreElements()) {
                alias = en.nextElement();
                X509Certificate cert = KeyManager.getSingleCertificate(privateKeyStore, alias);
                if (cert == null) continue;
                certificates.add(cert);
            }
            return certificates;
        }
        catch (KeyStoreException keyStoreException) {
            throw new CertificateRetrievalException(keyStoreException);
        }
    }

    private static X509Certificate getSingleCertificate(KeyStore privateKeyStore, String alias) throws KeyStoreException {
        Certificate[] arr$;
        int len$;
        int i$;
        Certificate[] certificateChain;
        if (privateKeyStore.isCertificateEntry(alias)) {
            return (X509Certificate)privateKeyStore.getCertificate(alias);
        }
        if (privateKeyStore.isKeyEntry(alias) && (certificateChain = privateKeyStore.getCertificateChain(alias)) != null && (i$ = 0) < (len$ = (arr$ = certificateChain).length)) {
            Certificate cert = arr$[i$];
            return (X509Certificate)cert;
        }
        return null;
    }

    public static void addKey(File privateKeyStoreFile, String privateKeyStoreType, char[] privateKeyStorePassword, String alias, PrivateKey key, char[] keyPassword, Certificate[] chain) throws CertificateException, IOException {
        try {
            KeyStore privateKeyStore = KeyManager.getKeyStore(privateKeyStoreFile, privateKeyStoreType, privateKeyStorePassword);
            privateKeyStore.setKeyEntry(alias, key, keyPassword, chain);
            FileOutputStream fos = new FileOutputStream(privateKeyStoreFile);
            privateKeyStore.store(fos, privateKeyStorePassword);
            fos.flush();
            fos.close();
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreStoringException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreStoringException(noSuchAlgorithmException);
        }
    }

    public static int getKeyUsage(X509Certificate cert) {
        int keyUsage = 0;
        boolean[] keyUsageB = cert.getKeyUsage();
        if (keyUsageB != null) {
            keyUsage = KeyManager.convertKeyUsageToInteger(keyUsageB);
        }
        return keyUsage;
    }

    public static boolean verifyIssuer(X509Certificate endCert, X509Certificate issuer) throws CertificateException {
        try {
            endCert.verify(issuer.getPublicKey());
            return true;
        }
        catch (SignatureException e) {
            LOGGER.trace((Object)"Invalid signature --> different issuer", (Throwable)e);
            return false;
        }
        catch (InvalidKeyException e) {
            LOGGER.trace((Object)"Invalid key --> different issuer", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            throw new CertificateException("Issuer could not be verified", e);
        }
    }

    public static boolean isSelfSigned(X509Certificate cert) throws CertificateException {
        return KeyManager.verifyIssuer(cert, cert);
    }

    public static X509Certificate getIssuerFromTrustStore(KeyStore trustStore, X509Certificate chainCert) throws KeyStoreException {
        if (trustStore == null) {
            return null;
        }
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate cert = trustStore.getCertificate(aliases.nextElement());
            if (!(cert instanceof X509Certificate) || !chainCert.getIssuerX500Principal().equals(((X509Certificate)cert).getSubjectX500Principal())) continue;
            try {
                chainCert.verify(cert.getPublicKey());
                return (X509Certificate)cert;
            }
            catch (Exception e) {
                LOGGER.trace((Object)"Invalid signature --> different issuer", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isTrustStoreCert(KeyStore trustStore, X509Certificate chainCert) throws KeyStoreException {
        if (trustStore != null) {
            return trustStore.getCertificateAlias(chainCert) != null;
        }
        return false;
    }

    private static int convertKeyUsageToInteger(boolean[] keyUsageB) {
        int keyUsage = 0;
        if (keyUsageB[0]) {
            keyUsage |= 0x80;
        }
        if (keyUsageB[1]) {
            keyUsage |= 0x40;
        }
        if (keyUsageB[2]) {
            keyUsage |= 0x20;
        }
        if (keyUsageB[3]) {
            keyUsage |= 0x10;
        }
        if (keyUsageB[4]) {
            keyUsage |= 8;
        }
        if (keyUsageB[5]) {
            keyUsage |= 4;
        }
        if (keyUsageB[6]) {
            keyUsage |= 2;
        }
        if (keyUsageB[7]) {
            keyUsage |= 1;
        }
        if (keyUsageB[8]) {
            keyUsage |= 0x8000;
        }
        return keyUsage;
    }

    public static class CertStoreException
    extends RuntimeException {
        private static final long serialVersionUID = -696029466310722821L;

        public CertStoreException(Exception exception) {
            super(exception);
        }
    }

    public static class CertificateRetrievalException
    extends RuntimeException {
        private static final long serialVersionUID = -696029466310722821L;

        public CertificateRetrievalException(Exception exception) {
            super(exception);
        }
    }

    public static class KeyStoreStoringException
    extends RuntimeException {
        private static final long serialVersionUID = -696029466310722821L;

        public KeyStoreStoringException(Exception exception) {
            super(exception);
        }
    }

    public static class KeyStoreOpeningException
    extends RuntimeException {
        private static final long serialVersionUID = -696029466310722821L;

        public KeyStoreOpeningException(Exception exception) {
            super(exception);
        }

        public KeyStoreOpeningException(String errorMessage, Exception exception) {
            super(errorMessage, exception);
        }
    }
}

