/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain;

import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class EndPointInformation {
    private Map<String, String> url2Service = new HashMap<String, String>();
    private Map<String, String> service2DefaultEndpoint = new HashMap<String, String>();
    private Map<String, List<String>> service2AllEndpoints = new HashMap<String, List<String>>();
    private Map<String, String> service2ActiveEndpoint = new HashMap<String, String>();
    private Map<String, CacheInformation> service2cache = new HashMap<String, CacheInformation>();

    public Map<String, String> getService2ActiveEndpoint() {
        return this.service2ActiveEndpoint;
    }

    public Map<String, String> getUrl2Service() {
        return Collections.unmodifiableMap(this.url2Service);
    }

    public Map<String, List<String>> getService2AllEndpoints() {
        return Collections.unmodifiableMap(this.service2AllEndpoints);
    }

    public Map<String, String> getService2DefaultEndpoint() {
        return Collections.unmodifiableMap(this.service2DefaultEndpoint);
    }

    public Map<String, CacheInformation> getService2CacheInformation() {
        return Collections.unmodifiableMap(this.service2cache);
    }

    public void register(String serviceName, String activeEndpoint, String defaultEndpoint, Collection<String> endpoints, CacheInformation cacheInformation) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)defaultEndpoint));
        this.service2DefaultEndpoint.put(serviceName, defaultEndpoint);
        if (StringUtils.isNotBlank((String)activeEndpoint)) {
            this.service2ActiveEndpoint.put(serviceName, activeEndpoint);
        }
        this.service2AllEndpoints.put(serviceName, new ArrayList<String>(endpoints));
        for (String endpoint : endpoints) {
            this.url2Service.put(endpoint, serviceName);
        }
        this.service2cache.put(serviceName, cacheInformation);
    }
}

