/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.test.kmehrcommons;

import java.util.ArrayList;

import be.ehealth.business.kmehrcommons.HcPartyUtil;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;


/**
 * tests the method {@link HcPartyUtil}.createMultipleHcpartiesFromConfig.
 * 
 * @author EHP
 * 
 */
public class HcPartyUtilsMultipleHcpartiesBuilderTest extends AbstractTestHcPartyUtils {

    @BeforeClass
    public static void init() throws Exception {
        initHcPartyUtilProperties();
    }

    @Test
    public void test() throws TechnicalConnectorException {
        final ArrayList<String> expectedResult = new ArrayList<String>();
        expectedResult.add("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><HcpartyType xmlns=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\" xmlns:ns2=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\"><ns2:id SL=\"application_ID\" SV=\"1.0\" S=\"LOCAL\">1990000332</ns2:id><ns2:cd SV=\"1.1\" S=\"CD-HCPARTY\">application</ns2:cd><ns2:name>Physician software name</ns2:name></HcpartyType>");
        expectedResult.add("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><HcpartyType xmlns=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\" xmlns:ns2=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\"><ns2:id SV=\"1.0\" S=\"ID-HCPARTY\">10998315001</ns2:id><ns2:id SV=\"1.0\" S=\"INSS\">52020845721</ns2:id><ns2:cd SV=\"1.1\" S=\"CD-HCPARTY\">persphysician</ns2:cd></HcpartyType>");
        checkResults(expectedResult, HcPartyUtil.createHcpartiesFromConfig("singlephysicianparty"));
    }


}
