/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import org.mockserver.filters.Filters;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.mock.action.HttpCallbackActionHandler;
import org.mockserver.mock.action.HttpForwardActionHandler;
import org.mockserver.mock.action.HttpResponseActionHandler;
import org.mockserver.model.Action;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class ActionHandler {
    private HttpForwardActionHandler httpForwardActionHandler = new HttpForwardActionHandler();
    private HttpCallbackActionHandler httpCallbackActionHandler = new HttpCallbackActionHandler();
    private HttpResponseActionHandler httpResponseActionHandler = new HttpResponseActionHandler();
    private Filters filters = new Filters();

    public ActionHandler(RequestLogFilter requestLogFilter) {
        this.filters.withFilter(HttpRequest.request(), new HopByHopHeaderFilter());
        this.filters.withFilter(HttpRequest.request(), requestLogFilter);
    }

    public HttpResponse processAction(Action action, HttpRequest httpRequest) {
        HttpResponse httpResponse = HttpResponse.notFoundResponse();
        httpRequest = this.filters.applyOnRequestFilters(httpRequest);
        if (action != null) {
            switch (action.getType()) {
                case FORWARD: {
                    httpResponse = this.httpForwardActionHandler.handle((HttpForward)action, httpRequest);
                    break;
                }
                case CALLBACK: {
                    httpResponse = this.httpCallbackActionHandler.handle((HttpClassCallback)action, httpRequest);
                    break;
                }
                case RESPONSE: {
                    httpResponse = this.httpResponseActionHandler.handle((HttpResponse)action);
                }
            }
        }
        return this.filters.applyOnResponseFilters(httpRequest, httpResponse);
    }
}

