/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.consumer;

import be.fedict.commons.eid.consumer.DateMask;
import be.fedict.commons.eid.consumer.DocumentType;
import be.fedict.commons.eid.consumer.Gender;
import be.fedict.commons.eid.consumer.SpecialOrganisation;
import be.fedict.commons.eid.consumer.SpecialStatus;
import be.fedict.commons.eid.consumer.WorkPermit;
import be.fedict.commons.eid.consumer.tlv.ChipNumberDataConvertor;
import be.fedict.commons.eid.consumer.tlv.ConvertData;
import be.fedict.commons.eid.consumer.tlv.DateOfBirthDataConvertor;
import be.fedict.commons.eid.consumer.tlv.DateOfBirthMaskDataConvertor;
import be.fedict.commons.eid.consumer.tlv.DocumentTypeConvertor;
import be.fedict.commons.eid.consumer.tlv.GenderDataConvertor;
import be.fedict.commons.eid.consumer.tlv.OriginalData;
import be.fedict.commons.eid.consumer.tlv.SpecialOrganisationConvertor;
import be.fedict.commons.eid.consumer.tlv.SpecialStatusConvertor;
import be.fedict.commons.eid.consumer.tlv.TlvField;
import be.fedict.commons.eid.consumer.tlv.ValidityDateDataConvertor;
import be.fedict.commons.eid.consumer.tlv.WorkPermitConvertor;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.Period;
import java.util.GregorianCalendar;

public class Identity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TlvField(value=1)
    public String cardNumber;
    @TlvField(value=2)
    @ConvertData(value=ChipNumberDataConvertor.class)
    public String chipNumber;
    @TlvField(value=3)
    @ConvertData(value=ValidityDateDataConvertor.class)
    public GregorianCalendar cardValidityDateBegin;
    @TlvField(value=4)
    @ConvertData(value=ValidityDateDataConvertor.class)
    public GregorianCalendar cardValidityDateEnd;
    @TlvField(value=5)
    public String cardDeliveryMunicipality;
    @TlvField(value=6)
    public String nationalNumber;
    @TlvField(value=7)
    public String name;
    @TlvField(value=8)
    public String firstName;
    @TlvField(value=9)
    public String middleName;
    @TlvField(value=10)
    public String nationality;
    @TlvField(value=11)
    public String placeOfBirth;
    @TlvField(value=12)
    @ConvertData(value=DateOfBirthDataConvertor.class)
    public GregorianCalendar dateOfBirth;
    @TlvField(value=12)
    @ConvertData(value=DateOfBirthMaskDataConvertor.class)
    public DateMask dateOfBirthMask;
    @TlvField(value=13)
    @ConvertData(value=GenderDataConvertor.class)
    public Gender gender;
    @TlvField(value=14)
    public String nobleCondition;
    @TlvField(value=15)
    @ConvertData(value=DocumentTypeConvertor.class)
    public DocumentType documentType;
    @TlvField(value=16)
    @ConvertData(value=SpecialStatusConvertor.class)
    public SpecialStatus specialStatus;
    @TlvField(value=17)
    public byte[] photoDigest;
    @TlvField(value=18)
    public String duplicate;
    @TlvField(value=19)
    @ConvertData(value=SpecialOrganisationConvertor.class)
    public SpecialOrganisation specialOrganisation;
    @TlvField(value=20)
    public boolean memberOfFamily;
    @TlvField(value=21)
    public String dateAndCountryOfProtection;
    @TlvField(value=22)
    @ConvertData(value=WorkPermitConvertor.class)
    public WorkPermit workPermit;
    @TlvField(value=23)
    public String employerVATNumber1;
    @TlvField(value=24)
    public String employerVATNumber2;
    @TlvField(value=25)
    public String regionalFileNumber;
    @TlvField(value=26)
    public byte[] basicPublicKeyDigest;
    @TlvField(value=27)
    public String brexitMention1;
    @TlvField(value=28)
    public String brexitMention2;
    @TlvField(value=29)
    public String cardAMention1;
    @TlvField(value=30)
    public String cardAMention2;
    @TlvField(value=31)
    @ConvertData(value=ValidityDateDataConvertor.class)
    public GregorianCalendar cardEUStartDate;
    @OriginalData
    public byte[] data;

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getChipNumber() {
        return this.chipNumber;
    }

    public GregorianCalendar getCardValidityDateBegin() {
        return this.cardValidityDateBegin;
    }

    public GregorianCalendar getCardValidityDateEnd() {
        return this.cardValidityDateEnd;
    }

    public String getCardDeliveryMunicipality() {
        return this.cardDeliveryMunicipality;
    }

    public String getNationalNumber() {
        return this.nationalNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getNationality() {
        return this.nationality;
    }

    public String getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public GregorianCalendar getDateOfBirth() {
        return this.dateOfBirth;
    }

    public DateMask getDateOfBirthMask() {
        return this.dateOfBirthMask;
    }

    public Gender getGender() {
        return this.gender;
    }

    public String getNobleCondition() {
        return this.nobleCondition;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public byte[] getPhotoDigest() {
        return this.photoDigest;
    }

    public SpecialStatus getSpecialStatus() {
        return this.specialStatus;
    }

    public String getDuplicate() {
        return this.duplicate;
    }

    public boolean isMemberOfFamily() {
        return this.memberOfFamily;
    }

    public SpecialOrganisation getSpecialOrganisation() {
        return this.specialOrganisation;
    }

    public String getDateAndCountryOfProtection() {
        return this.dateAndCountryOfProtection;
    }

    public WorkPermit getWorkPermit() {
        return this.workPermit;
    }

    public String getEmployerVATNumber1() {
        return this.employerVATNumber1;
    }

    public String getEmployerVATNumber2() {
        return this.employerVATNumber2;
    }

    public String getRegionalFileNumber() {
        return this.regionalFileNumber;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getBasicPublicKeyDigest() {
        return this.basicPublicKeyDigest;
    }

    public String getBrexitMention1() {
        return this.brexitMention1;
    }

    public String getBrexitMention2() {
        return this.brexitMention2;
    }

    public String getCardAMention1() {
        return this.cardAMention1;
    }

    public String getCardAMention2() {
        return this.cardAMention2;
    }

    public GregorianCalendar getCardEUStartDate() {
        return this.cardEUStartDate;
    }

    public int getAge() {
        return this.getAge(null);
    }

    public int getAge(Clock clock) {
        LocalDate dob = LocalDate.of(this.dateOfBirth.get(1), this.dateOfBirth.get(2) + 1, this.dateOfBirth.get(5));
        LocalDate now = null == clock ? LocalDate.now() : LocalDate.now(clock);
        Period age = Period.between(dob, now);
        int years = age.getYears();
        return years;
    }

    public String toString() {
        return "[" + this.name + " " + this.firstName + "]";
    }
}

